/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message;

import javax.annotation.Resource;
import javax.ejb.Stateless;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import org.jboss.aerogear.unifiedpush.api.PushMessageInformation;
import org.jboss.aerogear.unifiedpush.api.VariantMetricInformation;
import org.jboss.aerogear.unifiedpush.message.event.PushMessageCompletedEvent;
import org.jboss.aerogear.unifiedpush.message.event.TriggerMetricCollectionEvent;
import org.jboss.aerogear.unifiedpush.message.event.VariantCompletedEvent;
import org.jboss.aerogear.unifiedpush.message.jms.Dequeue;
import org.jboss.aerogear.unifiedpush.message.util.JmsClient;
import org.jboss.aerogear.unifiedpush.service.metrics.PushMessageMetricsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
public class MetricsCollector {
    private final Logger logger = LoggerFactory.getLogger(MetricsCollector.class);
    @Inject
    private PushMessageMetricsService metricsService;
    @Resource(mappedName="java:/queue/MetricsQueue")
    private Queue metricsQueue;
    @Resource(mappedName="java:/queue/BatchLoadedQueue")
    private Queue batchLoadedQueue;
    @Resource(mappedName="java:/queue/AllBatchesLoadedQueue")
    private Queue allBatchesLoaded;
    @Inject
    private Event<VariantCompletedEvent> variantCompleted;
    @Inject
    private Event<PushMessageCompletedEvent> pushMessageCompleted;
    @Inject
    private JmsClient jmsClient;

    public void collectMetrics(@Observes @Dequeue TriggerMetricCollectionEvent event) throws JMSException {
        String pushMessageInformationId = event.getPushMessageInformationId();
        PushMessageInformation pushMessageInformation = this.metricsService.getPushMessageInformation(pushMessageInformationId);
        this.metricsService.lock(pushMessageInformation);
        this.receiveVariantMetricsRemainingInQueues(pushMessageInformation);
        pushMessageInformation.getVariantInformations().stream().filter(this::areAllBatchesLoaded).forEach(variantMetricInformation -> {
            pushMessageInformation.setServedVariants(Integer.valueOf(1 + pushMessageInformation.getServedVariants()));
            this.logger.debug(String.format("All batches for variant %s were processed", variantMetricInformation.getVariantID()));
        });
        if (MetricsCollector.areAllVariantsServed(pushMessageInformation)) {
            event.markAllVariantsProcessed();
            this.logger.debug(String.format("All variants for application %s were processed", pushMessageInformation.getId()));
            this.pushMessageCompleted.fire((Object)new PushMessageCompletedEvent(pushMessageInformation.getId()));
        }
        this.metricsService.updatePushMessageInformation(pushMessageInformation);
    }

    private void receiveVariantMetricsRemainingInQueues(PushMessageInformation pushMessageInformation) throws JMSException {
        ObjectMessage message;
        while ((message = this.receiveVariantMetricInformation(pushMessageInformation.getId())) != null) {
            this.updateVariantMetrics(pushMessageInformation, (VariantMetricInformation)message.getObject());
        }
    }

    private static boolean areAllVariantsServed(PushMessageInformation pushMessageInformation) {
        return MetricsCollector.areIntegersEqual(pushMessageInformation.getServedVariants(), pushMessageInformation.getTotalVariants());
    }

    private void updateVariantMetrics(PushMessageInformation pushMessageInformation, VariantMetricInformation variantMetricInformation) {
        pushMessageInformation.setTotalReceivers(Long.valueOf(pushMessageInformation.getTotalReceivers() + variantMetricInformation.getReceivers()));
        int loadedBatches = this.countLoadedBatches(variantMetricInformation);
        variantMetricInformation.setTotalBatches(Integer.valueOf(variantMetricInformation.getTotalBatches() + loadedBatches));
        boolean updatedExisting = false;
        for (VariantMetricInformation existingMetric : pushMessageInformation.getVariantInformations()) {
            if (!variantMetricInformation.getVariantID().equals(existingMetric.getVariantID())) continue;
            updatedExisting = true;
            MetricsCollector.updateExistingMetric(existingMetric, variantMetricInformation);
            variantMetricInformation = existingMetric;
            break;
        }
        if (!updatedExisting) {
            pushMessageInformation.addVariantInformations(variantMetricInformation);
        }
    }

    private int countLoadedBatches(VariantMetricInformation variantMetricInformation) {
        int loadedBatches = 0;
        while (this.receiveBatchLoadedEvent(variantMetricInformation) != null) {
            ++loadedBatches;
        }
        return loadedBatches;
    }

    private boolean areAllBatchesLoaded(VariantMetricInformation variantMetricInformation) {
        if (MetricsCollector.areIntegersEqual(variantMetricInformation.getTotalBatches(), variantMetricInformation.getServedBatches())) {
            return this.receiveAllBatchedLoadedEvent(variantMetricInformation) != null;
        }
        return false;
    }

    private static void updateExistingMetric(VariantMetricInformation existing, VariantMetricInformation update) {
        existing.setReceivers(Long.valueOf(existing.getReceivers() + update.getReceivers()));
        existing.setServedBatches(Integer.valueOf(existing.getServedBatches() + update.getServedBatches()));
        existing.setTotalBatches(Integer.valueOf(existing.getTotalBatches() + update.getTotalBatches()));
        if (existing.getDeliveryStatus() == null) {
            existing.setDeliveryStatus(update.getDeliveryStatus());
        }
        if (Boolean.TRUE.equals(existing.getDeliveryStatus()) && Boolean.FALSE.equals(update.getDeliveryStatus())) {
            existing.setDeliveryStatus(Boolean.FALSE);
        }
        if (existing.getReason() == null && update.getReason() != null) {
            existing.setReason(update.getReason());
        }
    }

    private static boolean areIntegersEqual(int i1, int i2) {
        return i1 == i2;
    }

    private ObjectMessage receiveVariantMetricInformation(String pushMessageInformationId) {
        return this.jmsClient.receive().inTransaction().noWait().withSelector("pushMessageInformationId = '%s'", pushMessageInformationId).from((Destination)this.metricsQueue);
    }

    private ObjectMessage receiveBatchLoadedEvent(VariantMetricInformation variantMetricInformation) {
        String pushMessageInformationId = variantMetricInformation.getPushMessageInformation().getId();
        String variantID = variantMetricInformation.getVariantID();
        return this.jmsClient.receive().inTransaction().noWait().withSelector("variantID = '%s'", variantID + ":" + pushMessageInformationId).from((Destination)this.batchLoadedQueue);
    }

    private ObjectMessage receiveAllBatchedLoadedEvent(VariantMetricInformation variantMetricInformation) {
        String pushMessageInformationId = variantMetricInformation.getPushMessageInformation().getId();
        String variantID = variantMetricInformation.getVariantID();
        return this.jmsClient.receive().inTransaction().noWait().withSelector("variantID = '%s'", variantID + ":" + pushMessageInformationId).from((Destination)this.allBatchesLoaded);
    }
}

