/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.jms;

import java.io.Serializable;
import javax.annotation.Resource;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Topic;
import org.jboss.aerogear.unifiedpush.message.exception.MessageDeliveryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJMSMessageListener<T>
implements MessageListener {
    @Resource(mappedName="java:/ConnectionFactory")
    private ConnectionFactory connectionFactory;
    private final Logger logger = LoggerFactory.getLogger(AbstractJMSMessageListener.class);

    public abstract void onMessage(T var1);

    public void onMessage(Message jmsMessage) {
        block5: {
            try {
                if (jmsMessage instanceof ObjectMessage) {
                    Serializable messageObject = ((ObjectMessage)jmsMessage).getObject();
                    try {
                        Serializable message = messageObject;
                        this.onMessage(message);
                        break block5;
                    }
                    catch (ClassCastException e) {
                        throw new IllegalStateException("Received message of wrong payload type " + messageObject.getClass() + " to destination " + AbstractJMSMessageListener.getDestinationName(jmsMessage));
                    }
                }
                this.logger.warn("Received message of wrong type {} to destination {}", (Object)jmsMessage.getClass().getName(), (Object)AbstractJMSMessageListener.getDestinationName(jmsMessage));
            }
            catch (JMSException e) {
                throw new MessageDeliveryException("Failed to handle message from destination " + AbstractJMSMessageListener.getDestinationName(jmsMessage), e);
            }
        }
    }

    private static String getDestinationName(Message message) {
        try {
            Destination destination = message.getJMSDestination();
            if (destination instanceof Queue) {
                return ((Queue)destination).getQueueName();
            }
            if (destination instanceof Topic) {
                return ((Topic)destination).getTopicName();
            }
            throw new IllegalStateException("Can't recognize destination type for " + destination.getClass());
        }
        catch (JMSException e) {
            throw new IllegalStateException("Can't extract destination name from JMS message: " + message, e);
        }
    }
}

