/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.sender;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.api.VariantType;
import org.jboss.aerogear.unifiedpush.message.Message;
import org.jboss.aerogear.unifiedpush.message.UnifiedPushMessage;
import org.jboss.aerogear.unifiedpush.message.sender.NotificationSenderCallback;
import org.jboss.aerogear.unifiedpush.message.sender.PushNotificationSender;
import org.jboss.aerogear.unifiedpush.message.sender.SenderType;
import org.jboss.aerogear.unifiedpush.message.sender.WNSPushNotificationSender;
import org.jboss.aerogear.unifiedpush.message.windows.Windows;
import org.jboss.aerogear.windows.mpns.MPNS;
import org.jboss.aerogear.windows.mpns.MpnsNotification;
import org.jboss.aerogear.windows.mpns.MpnsService;
import org.jboss.aerogear.windows.mpns.notifications.TileNotification;
import org.jboss.aerogear.windows.mpns.notifications.ToastNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SenderType(value=VariantType.WINDOWS_MPNS)
public class MPNSPushNotificationSender
implements PushNotificationSender {
    private final Logger logger = LoggerFactory.getLogger(MPNSPushNotificationSender.class);

    @Override
    public void sendPushMessage(Variant variant, Collection<String> clientIdentifiers, UnifiedPushMessage pushMessage, String pushMessageInformationId, NotificationSenderCallback senderCallback) {
        TileNotification notification;
        MpnsService mpnsService;
        block13: {
            Message message;
            block12: {
                if (clientIdentifiers.isEmpty()) {
                    return;
                }
                mpnsService = MPNS.newService().build();
                message = pushMessage.getMessage();
                if (message.getWindows().getType() == null) break block12;
                switch (message.getWindows().getType()) {
                    case toast: {
                        ToastNotification.Builder builder = MPNS.newNotification().toast().parameter(MPNSPushNotificationSender.createLaunchParam(message.getWindows().getPage(), message.getAlert(), message.getUserData(), pushMessageInformationId)).title(message.getAlert());
                        if (!message.getWindows().getTextFields().isEmpty()) {
                            builder.subtitle((String)message.getWindows().getTextFields().get(0));
                        }
                        notification = builder.build();
                        break block13;
                    }
                    case badge: {
                        notification = MPNS.newNotification().tile().count(message.getBadge()).build();
                        break block13;
                    }
                    case raw: {
                        notification = MPNS.newNotification().raw().body(message.getAlert()).build();
                        break block13;
                    }
                    case tile: {
                        List textFields;
                        Windows windows = message.getWindows();
                        TileNotification.Builder tile = MPNS.newNotification().tile();
                        tile.title(message.getAlert());
                        List images = windows.getImages();
                        if (images.size() >= 1) {
                            tile.backgroundImage((String)images.get(0));
                        }
                        if (images.size() >= 2) {
                            tile.backBackgroundImage((String)images.get(1));
                        }
                        if ((textFields = windows.getTextFields()).size() >= 1) {
                            tile.backTitle((String)textFields.get(0));
                        }
                        if (textFields.size() >= 2) {
                            tile.backContent((String)textFields.get(1));
                        }
                        notification = tile.build();
                        break block13;
                    }
                    default: {
                        senderCallback.onError("unknown type: " + message.getWindows().getType());
                        throw new IllegalArgumentException("unknown type: " + message.getWindows().getType());
                    }
                }
            }
            notification = MPNS.newNotification().toast().parameter(MPNSPushNotificationSender.createLaunchParam(message.getWindows().getPage(), message.getAlert(), message.getUserData(), pushMessageInformationId)).title(message.getAlert()).build();
        }
        clientIdentifiers.forEach(arg_0 -> MPNSPushNotificationSender.lambda$sendPushMessage$1(mpnsService, (MpnsNotification)notification, arg_0));
        this.logger.info(String.format("Sent push notification to MPNs for %d tokens", clientIdentifiers.size()));
        senderCallback.onSuccess();
    }

    static String createLaunchParam(String page, String message, Map<String, Object> data, String pushMessageInformationId) {
        if (page != null) {
            return WNSPushNotificationSender.createLaunchParam(page, message, data, pushMessageInformationId);
        }
        return null;
    }

    private static /* synthetic */ void lambda$sendPushMessage$1(MpnsService mpnsService, MpnsNotification notification, String clientIdentifier) {
        mpnsService.push(clientIdentifier, notification);
    }
}

