/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.util;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.ejb.Stateless;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import org.jboss.aerogear.unifiedpush.message.exception.MessageDeliveryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
public class JmsClient {
    private static final Logger logger = LoggerFactory.getLogger(JmsClient.class);
    @Resource(mappedName="java:/ConnectionFactory")
    private ConnectionFactory connectionFactory;
    @Resource(mappedName="java:/JmsXA")
    private ConnectionFactory xaConnectionFactory;

    public JmsSender send(Serializable message) {
        return new JmsSender(message);
    }

    public JmsReceiver receive() {
        return new JmsReceiver();
    }

    private static class WaitSpecificTime
    implements Wait {
        private long time;

        WaitSpecificTime(long time) {
            this.time = time;
        }

        public long getTime() {
            return this.time;
        }
    }

    private static class NoWait
    implements Wait {
        private NoWait() {
        }
    }

    private static class WaitIndefinitely
    implements Wait {
        private WaitIndefinitely() {
        }
    }

    private static interface Wait {
    }

    public class JmsSender {
        private Serializable message;
        private boolean transacted;
        private Map<String, Object> properties = new LinkedHashMap<String, Object>();
        private int autoAcknowledgeMode = 1;

        public JmsSender(Serializable message) {
            this.message = message;
        }

        public JmsSender inTransaction() {
            this.transacted = true;
            return this;
        }

        public JmsSender withProperty(String name, String value) {
            if (value == null) {
                throw new NullPointerException("property value");
            }
            this.properties.put(name, value);
            return this;
        }

        public JmsSender withProperty(String name, Long value) {
            if (value == null) {
                throw new NullPointerException("property value");
            }
            this.properties.put(name, value);
            return this;
        }

        public JmsSender withDuplicateDetectionId(String duplicateDetectionId) {
            if (duplicateDetectionId == null) {
                throw new NullPointerException("duplicateDetectionId");
            }
            this.properties.put("_HQ_DUPL_ID", duplicateDetectionId);
            this.properties.put("_AMQ_DUPL_ID", duplicateDetectionId);
            return this;
        }

        public JmsSender withDelayedDelivery(Long delayMs) {
            if (delayMs == null) {
                throw new NullPointerException("delayMs");
            }
            this.properties.put("_HQ_SCHED_DELIVERY", new Long(System.currentTimeMillis() + delayMs));
            this.properties.put("_AMQ_SCHED_DELIVERY", new Long(System.currentTimeMillis() + delayMs));
            return this;
        }

        public void to(Destination destination) {
            Connection connection = null;
            try {
                connection = this.transacted ? JmsClient.this.xaConnectionFactory.createConnection() : JmsClient.this.connectionFactory.createConnection();
                Session session = connection.createSession(this.transacted, this.autoAcknowledgeMode);
                MessageProducer messageProducer = session.createProducer(destination);
                connection.start();
                ObjectMessage objectMessage = session.createObjectMessage(this.message);
                for (Map.Entry<String, Object> property : this.properties.entrySet()) {
                    Object value = property.getValue();
                    if (value instanceof String) {
                        objectMessage.setStringProperty(property.getKey(), (String)value);
                        continue;
                    }
                    if (!(value instanceof Long)) continue;
                    objectMessage.setLongProperty(property.getKey(), ((Long)value).longValue());
                }
                messageProducer.send((Message)objectMessage);
            }
            catch (JMSException e) {
                throw new MessageDeliveryException("Failed to queue push message for further processing", e);
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (JMSException e) {
                        logger.error("Failed to close JMS connection: ", (Throwable)e);
                    }
                }
            }
        }
    }

    public class JmsReceiver {
        private boolean transacted;
        private String selector;
        private Wait wait = new WaitIndefinitely();
        private int acknowledgeMode = 1;
        private boolean autoClose = true;
        private Connection connection;

        public JmsReceiver inTransaction() {
            this.transacted = true;
            return this;
        }

        public JmsReceiver withSelector(String selector, Object ... args) {
            this.selector = String.format(selector, args);
            return this;
        }

        public JmsReceiver noWait() {
            this.wait = new NoWait();
            return this;
        }

        public JmsReceiver withTimeout(long timeout) {
            this.wait = new WaitSpecificTime(timeout);
            return this;
        }

        public JmsReceiver withAcknowledgeMode(int acknowledgeMode) {
            this.acknowledgeMode = acknowledgeMode;
            return this;
        }

        public JmsReceiver noAutoClose() {
            this.autoClose = false;
            return this;
        }

        public void close() {
            try {
                this.connection.close();
            }
            catch (JMSException e) {
                throw new java.lang.IllegalStateException(e);
            }
        }

        public ObjectMessage from(Destination destination) {
            try {
                ObjectMessage objectMessage;
                this.connection = this.transacted ? JmsClient.this.xaConnectionFactory.createConnection() : JmsClient.this.connectionFactory.createConnection();
                Session session = this.connection.createSession(this.transacted, this.acknowledgeMode);
                MessageConsumer messageConsumer = this.selector != null ? session.createConsumer(destination, this.selector) : session.createConsumer(destination);
                this.connection.start();
                if (this.wait instanceof WaitIndefinitely) {
                    objectMessage = (ObjectMessage)messageConsumer.receive();
                } else if (this.wait instanceof NoWait) {
                    objectMessage = (ObjectMessage)messageConsumer.receiveNoWait();
                } else if (this.wait instanceof WaitSpecificTime) {
                    objectMessage = (ObjectMessage)messageConsumer.receive(((WaitSpecificTime)this.wait).getTime());
                } else {
                    throw new IllegalStateException("Unknown wait: " + this.wait.getClass());
                }
                ObjectMessage objectMessage2 = objectMessage;
                return objectMessage2;
            }
            catch (JMSException e) {
                throw new MessageDeliveryException("Failed to queue push message for further processing", e);
            }
            finally {
                if (this.connection != null && this.autoClose) {
                    try {
                        this.connection.close();
                    }
                    catch (JMSException e) {
                        logger.error("Failed to close JMS connection: ", (Throwable)e);
                    }
                }
            }
        }
    }
}

