/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.jms;

import java.io.Serializable;
import javax.annotation.Resource;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Session;
import org.jboss.aerogear.unifiedpush.message.exception.MessageDeliveryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJMSMessageConsumer {
    private static final Logger logger = LoggerFactory.getLogger(AbstractJMSMessageConsumer.class);
    @Resource(mappedName="java:/JmsXA")
    private ConnectionFactory xaConnectionFactory;

    protected <T extends Serializable> T receiveInTransactionNoWait(Queue queue) {
        return this.receiveInTransactionNoWait(queue, null, null);
    }

    protected <T extends Serializable> T receiveInTransactionNoWait(Queue queue, String propertyName, String propertyValue) {
        Connection connection = null;
        try {
            connection = this.xaConnectionFactory.createConnection();
            Session session = connection.createSession(false, 1);
            MessageConsumer messageConsumer = propertyName != null ? session.createConsumer((Destination)queue, String.format("%s = '%s'", propertyName, propertyValue)) : session.createConsumer((Destination)queue);
            connection.start();
            ObjectMessage objectMessage = (ObjectMessage)messageConsumer.receiveNoWait();
            if (objectMessage != null) {
                Serializable serializable = objectMessage.getObject();
                return (T)serializable;
            }
            T t = null;
            return t;
        }
        catch (JMSException e) {
            throw new MessageDeliveryException("Failed to queue push message for further processing", e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException e) {
                    logger.error("Failed to close JMS connection: ", (Throwable)e);
                }
            }
        }
    }
}

