/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.jms;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.ejb.Stateless;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.jms.JMSException;
import org.jboss.aerogear.unifiedpush.api.PushMessageInformation;
import org.jboss.aerogear.unifiedpush.api.VariantMetricInformation;
import org.jboss.aerogear.unifiedpush.message.event.MetricsProcessingStartedEvent;
import org.jboss.aerogear.unifiedpush.message.event.TriggerMetricCollectionEvent;
import org.jboss.aerogear.unifiedpush.message.event.TriggerVariantMetricCollectionEvent;
import org.jboss.aerogear.unifiedpush.message.jms.Dequeue;
import org.jboss.aerogear.unifiedpush.message.jms.DispatchToQueue;
import org.jboss.aerogear.unifiedpush.service.metrics.PushMessageMetricsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
public class MetricCollectionTrigger {
    private final Logger logger = LoggerFactory.getLogger(MetricCollectionTrigger.class);
    private static final Set<String> METRICS_PROCESSING_STARTED_FOR_IDS = Collections.newSetFromMap(new ConcurrentHashMap());
    @Inject
    @DispatchToQueue
    private Event<MetricsProcessingStartedEvent> broadcastMetricsProcessingStarted;
    @Inject
    @DispatchToQueue
    private Event<TriggerMetricCollectionEvent> triggerMetricCollection;
    @Inject
    private PushMessageMetricsService metricsService;

    public void tryToStartMetricCollection(@Observes @Dequeue TriggerVariantMetricCollectionEvent event) {
        String pushMessageInformationId = event.getPushMessageInformationId();
        if (!METRICS_PROCESSING_STARTED_FOR_IDS.contains(pushMessageInformationId)) {
            if (this.detectMetricsProcessingStartedFromDB(pushMessageInformationId)) {
                this.logger.debug(String.format("Detected that metrics collection already started from DB state for push message %s", pushMessageInformationId));
                METRICS_PROCESSING_STARTED_FOR_IDS.add(pushMessageInformationId);
            } else if (!METRICS_PROCESSING_STARTED_FOR_IDS.contains(pushMessageInformationId)) {
                METRICS_PROCESSING_STARTED_FOR_IDS.add(pushMessageInformationId);
                this.logger.debug(String.format("Broadcasting information that metrics processing started for push message %s", pushMessageInformationId));
                this.broadcastMetricsProcessingStarted.fire((Object)new MetricsProcessingStartedEvent(pushMessageInformationId));
                this.logger.debug(String.format("Trigger metric collection process for push message %s", pushMessageInformationId));
                this.triggerMetricCollection.fire((Object)new TriggerMetricCollectionEvent(pushMessageInformationId));
            }
        }
    }

    private boolean detectMetricsProcessingStartedFromDB(String pushMessageInformationId) {
        PushMessageInformation pmi = this.metricsService.getPushMessageInformation(pushMessageInformationId);
        if (pmi.getServedVariants() > 0) {
            return true;
        }
        for (VariantMetricInformation vmi : pmi.getVariantInformations()) {
            if (vmi.getServedBatches() <= 0 && vmi.getTotalBatches() <= 0) continue;
            return true;
        }
        return false;
    }

    public void markMetricsProcessingAsStarted(@Observes @Dequeue MetricsProcessingStartedEvent event) throws JMSException {
        this.logger.debug(String.format("Received signal that metrics collection started for push message %s", event.getPushMessageInformationId()));
        METRICS_PROCESSING_STARTED_FOR_IDS.add(event.getPushMessageInformationId());
    }
}

