/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.sender.apns;

import java.io.ByteArrayInputStream;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.x500.X500Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApnsUtil {
    private static final String KEYSTORE_TYPE = "PKCS12";
    private static final String TOPIC_PATTERN = ".*UID=([^,]+).*";
    private static final Logger LOGGER = LoggerFactory.getLogger(ApnsUtil.class);

    private ApnsUtil() {
    }

    public static String readDefaultTopic(byte[] keystore, char[] password) {
        try {
            KeyStore keyStore = KeyStore.getInstance(KEYSTORE_TYPE);
            keyStore.load(new ByteArrayInputStream(keystore), password);
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                Pattern pattern;
                Matcher matcher;
                String alias = aliases.nextElement();
                X509Certificate certificate = (X509Certificate)keyStore.getCertificate(alias);
                X500Principal subjectX500Principal = certificate.getSubjectX500Principal();
                String subject = subjectX500Principal.getName();
                if (subject == null || !(matcher = (pattern = Pattern.compile(TOPIC_PATTERN)).matcher(subject)).matches()) continue;
                return matcher.group(1);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error parsing .p12 file content", (Throwable)e);
        }
        return null;
    }
}

