/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message;

import java.lang.annotation.Annotation;
import java.util.Collection;
import javax.ejb.Stateless;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.aerogear.unifiedpush.api.FlatPushMessageInformation;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.message.UnifiedPushMessage;
import org.jboss.aerogear.unifiedpush.message.holder.MessageHolderWithTokens;
import org.jboss.aerogear.unifiedpush.message.jms.Dequeue;
import org.jboss.aerogear.unifiedpush.message.sender.NotificationSenderCallback;
import org.jboss.aerogear.unifiedpush.message.sender.PushNotificationSender;
import org.jboss.aerogear.unifiedpush.message.sender.SenderTypeLiteral;
import org.jboss.aerogear.unifiedpush.service.metrics.PushMessageMetricsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
public class NotificationDispatcher {
    private final Logger logger = LoggerFactory.getLogger(NotificationDispatcher.class);
    @Inject
    @Any
    private Instance<PushNotificationSender> senders;
    @Inject
    private PushMessageMetricsService pushMessageMetricsService;

    public void sendMessagesToPushNetwork(@Observes @Dequeue MessageHolderWithTokens msg) {
        Variant variant = msg.getVariant();
        UnifiedPushMessage unifiedPushMessage = msg.getUnifiedPushMessage();
        Collection<String> deviceTokens = msg.getDeviceTokens();
        this.logger.info(String.format("Received UnifiedPushMessage from JMS queue, will now trigger the Push Notification delivery for the %s variant (%s)", variant.getType().getTypeName(), variant.getVariantID()));
        ((PushNotificationSender)this.senders.select(new Annotation[]{new SenderTypeLiteral(variant.getType())}).get()).sendPushMessage(variant, deviceTokens, unifiedPushMessage, msg.getPushMessageInformation().getId(), new SenderServiceCallback(variant, deviceTokens.size(), msg.getPushMessageInformation()));
    }

    private class SenderServiceCallback
    implements NotificationSenderCallback {
        private final Variant variant;
        private final int tokenSize;
        private final FlatPushMessageInformation pushMessageInformation;

        public SenderServiceCallback(Variant variant, int tokenSize, FlatPushMessageInformation pushMessageInformation) {
            this.variant = variant;
            this.tokenSize = tokenSize;
            this.pushMessageInformation = pushMessageInformation;
        }

        @Override
        public void onSuccess() {
            NotificationDispatcher.this.logger.debug(String.format("Sent '%s' message to '%d' devices", this.variant.getType().getTypeName(), this.tokenSize));
        }

        @Override
        public void onError(String reason) {
            NotificationDispatcher.this.logger.warn(String.format("Error on '%s' delivery: %s", this.variant.getType().getTypeName(), reason));
            NotificationDispatcher.this.pushMessageMetricsService.appendError(this.pushMessageInformation, this.variant, reason);
        }
    }
}

