/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.cache;

import com.turo.pushy.apns.ApnsClient;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.ejb.Singleton;
import javax.enterprise.event.Observes;
import net.jodah.expiringmap.ExpirationPolicy;
import net.jodah.expiringmap.ExpiringMap;
import org.jboss.aerogear.unifiedpush.api.iOSVariant;
import org.jboss.aerogear.unifiedpush.event.iOSVariantUpdateEvent;
import org.jboss.aerogear.unifiedpush.message.cache.ServiceConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SimpleApnsClientCache {
    private final Logger logger = LoggerFactory.getLogger(SimpleApnsClientCache.class);
    final ConcurrentMap<String, ApnsClient> apnsClientExpiringMap = ExpiringMap.builder().expiration(12L, TimeUnit.HOURS).expirationPolicy(ExpirationPolicy.ACCESSED).asyncExpirationListener((variantID, apnsClient) -> {
        if (apnsClient.isConnected()) {
            this.logger.info("APNs connection for iOS Variant ({}) was inactive last 12 hours, disconnecting...", variantID);
            Future disconnectFuture = apnsClient.disconnect();
            disconnectFuture.addListener(future -> {
                if (future.isSuccess()) {
                    this.logger.debug("Disconnected from APNS due to inactive connection for iOS Variant ({})", variantID);
                } else {
                    Throwable t = future.cause();
                    this.logger.warn(t.getMessage(), t);
                }
            });
        }
    }).build();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApnsClient getApnsClientForVariant(iOSVariant iOSVariant2, ServiceConstructor<ApnsClient> constructor) {
        String connectionKey = this.extractConnectionKey(iOSVariant2);
        ApnsClient client = (ApnsClient)this.apnsClientExpiringMap.get(connectionKey);
        if (client == null) {
            this.logger.debug("no cached connection for {}, establishing it", (Object)connectionKey);
            ConcurrentMap<String, ApnsClient> concurrentMap = this.apnsClientExpiringMap;
            synchronized (concurrentMap) {
                client = constructor.construct();
                if (client.isConnected()) {
                    this.putApnsClientForVariantID(connectionKey, client);
                }
                return client;
            }
        }
        this.logger.debug("reusing cached connection for {}", (Object)connectionKey);
        return client;
    }

    public void disconnectOnChange(@Observes iOSVariantUpdateEvent iOSVariantUpdateEvent2) {
        iOSVariant variant = iOSVariantUpdateEvent2.getiOSVariant();
        String connectionKey = this.extractConnectionKey(variant);
        ApnsClient client = (ApnsClient)this.apnsClientExpiringMap.remove(connectionKey);
        this.logger.debug("Removed client from cache for {}", (Object)variant.getVariantID());
        if (client != null) {
            this.tearDownApnsHttp2Connection(client);
        }
    }

    private String extractConnectionKey(iOSVariant iOSVariant2) {
        StringBuilder sb = new StringBuilder().append(iOSVariant2.getVariantID()).append(iOSVariant2.isProduction() ? "-prod" : "-dev");
        return sb.toString();
    }

    private void putApnsClientForVariantID(String variantID, ApnsClient apnsClient) {
        ApnsClient client = this.apnsClientExpiringMap.putIfAbsent(variantID, apnsClient);
        if (client != null) {
            this.logger.warn("duplicate connection in pool, immediately shutting down the new connection");
            this.tearDownApnsHttp2Connection(apnsClient);
        }
    }

    @PreDestroy
    public void cleanUpConnection() {
        this.logger.debug("remove all connections before server shutdown");
        for (Map.Entry cachedConnection : this.apnsClientExpiringMap.entrySet()) {
            ApnsClient connection = (ApnsClient)cachedConnection.getValue();
            this.tearDownApnsHttp2Connection(connection);
        }
    }

    private void tearDownApnsHttp2Connection(ApnsClient client) {
        if (client.isConnected()) {
            this.logger.trace("Tearing down connection to APNs for the given client");
            client.disconnect().addListener((GenericFutureListener)new ApnsDisconnectFutureListener());
        }
    }

    private class ApnsDisconnectFutureListener
    implements GenericFutureListener<Future<? super Void>> {
        private ApnsDisconnectFutureListener() {
        }

        public void operationComplete(Future<? super Void> future) throws Exception {
            if (future.isSuccess()) {
                SimpleApnsClientCache.this.logger.debug("Successfully disconnected connection...");
            } else {
                Throwable t = future.cause();
                SimpleApnsClientCache.this.logger.warn(t.getMessage(), t);
            }
        }
    }
}

