/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.jms;

import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.aerogear.unifiedpush.message.exception.DispatchInitiationException;
import org.jboss.aerogear.unifiedpush.message.holder.MessageHolderWithTokens;
import org.jboss.aerogear.unifiedpush.message.jms.AbstractJMSMessageListener;
import org.jboss.aerogear.unifiedpush.message.jms.Dequeue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TransactionManagement(value=TransactionManagementType.CONTAINER)
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class MessageHolderWithTokensConsumer
extends AbstractJMSMessageListener<MessageHolderWithTokens> {
    private final Logger logger = LoggerFactory.getLogger(MessageHolderWithTokensConsumer.class);
    @Inject
    @Dequeue
    private Event<MessageHolderWithTokens> dequeueEvent;

    @Override
    public void onMessage(MessageHolderWithTokens message) {
        try {
            this.logger.trace("receiving tokens from queue, triggering Notification Dispatcher to pick the right sender");
            this.dequeueEvent.fire((Object)message);
        }
        catch (DispatchInitiationException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.error("NotificationDispatcher or PushNotificationSender unexpectedly failed, the message won't be redelivered", (Throwable)e);
        }
    }
}

