/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.jms;

import javax.annotation.Resource;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.jms.Destination;
import javax.jms.Queue;
import org.jboss.aerogear.unifiedpush.api.VariantType;
import org.jboss.aerogear.unifiedpush.message.holder.MessageHolderWithTokens;
import org.jboss.aerogear.unifiedpush.message.jms.AbstractJMSMessageProducer;
import org.jboss.aerogear.unifiedpush.message.jms.DispatchToQueue;
import org.jboss.aerogear.unifiedpush.message.util.JmsClient;

public class MessageHolderWithTokensProducer
extends AbstractJMSMessageProducer {
    @Inject
    private JmsClient jmsClient;
    @Resource(mappedName="java:/queue/AdmTokenBatchQueue")
    private Queue admTokenBatchQueue;
    @Resource(mappedName="java:/queue/APNsTokenBatchQueue")
    private Queue apnsTokenBatchQueue;
    @Resource(mappedName="java:/queue/GCMTokenBatchQueue")
    private Queue gcmTokenBatchQueue;
    @Resource(mappedName="java:/queue/WNSTokenBatchQueue")
    private Queue wnsTokenBatchQueue;

    public void queueMessageVariantForProcessing(@Observes @DispatchToQueue MessageHolderWithTokens msg) {
        String deduplicationId = String.format("%s-%s", msg.getPushMessageInformation().getId(), msg.getSerialId());
        this.jmsClient.send(msg).withDuplicateDetectionId(deduplicationId).to((Destination)this.selectQueue(msg.getVariant().getType()));
    }

    private Queue selectQueue(VariantType variantType) {
        switch (variantType) {
            case ADM: {
                return this.admTokenBatchQueue;
            }
            case ANDROID: {
                return this.gcmTokenBatchQueue;
            }
            case IOS: {
                return this.apnsTokenBatchQueue;
            }
            case WINDOWS_WNS: {
                return this.wnsTokenBatchQueue;
            }
        }
        throw new IllegalStateException("Unknown variant type queue");
    }
}

