/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.sender.apns;

import com.turo.pushy.apns.ApnsClient;
import com.turo.pushy.apns.ApnsClientBuilder;
import com.turo.pushy.apns.ApnsPushNotification;
import com.turo.pushy.apns.PushNotificationResponse;
import com.turo.pushy.apns.proxy.HttpProxyHandlerFactory;
import com.turo.pushy.apns.proxy.ProxyHandlerFactory;
import com.turo.pushy.apns.proxy.Socks5ProxyHandlerFactory;
import com.turo.pushy.apns.util.ApnsPayloadBuilder;
import com.turo.pushy.apns.util.SimpleApnsPushNotification;
import io.netty.util.concurrent.Future;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.ejb.Stateless;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.api.VariantType;
import org.jboss.aerogear.unifiedpush.api.iOSVariant;
import org.jboss.aerogear.unifiedpush.event.iOSVariantUpdateEvent;
import org.jboss.aerogear.unifiedpush.message.Message;
import org.jboss.aerogear.unifiedpush.message.UnifiedPushMessage;
import org.jboss.aerogear.unifiedpush.message.apns.APNs;
import org.jboss.aerogear.unifiedpush.message.cache.SimpleApnsClientCache;
import org.jboss.aerogear.unifiedpush.message.sender.NotificationSenderCallback;
import org.jboss.aerogear.unifiedpush.message.sender.PushNotificationSender;
import org.jboss.aerogear.unifiedpush.message.sender.SenderType;
import org.jboss.aerogear.unifiedpush.message.sender.apns.ApnsUtil;
import org.jboss.aerogear.unifiedpush.service.ClientInstallationService;
import org.jboss.aerogear.unifiedpush.service.proxy.ProxyConfiguration;
import org.jboss.aerogear.unifiedpush.system.ConfigurationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
@SenderType(value=VariantType.IOS)
public class PushyApnsSender
implements PushNotificationSender {
    private final Logger logger = LoggerFactory.getLogger(PushyApnsSender.class);
    public static final String CUSTOM_AEROGEAR_APNS_PUSH_HOST = "custom.aerogear.apns.push.host";
    public static final String CUSTOM_AEROGEAR_APNS_PUSH_PORT = "custom.aerogear.apns.push.port";
    private static final String customAerogearApnsPushHost = ConfigurationUtils.tryGetProperty((String)"custom.aerogear.apns.push.host");
    private static final Integer customAerogearApnsPushPort = ConfigurationUtils.tryGetIntegerProperty((String)"custom.aerogear.apns.push.port");
    private final ConcurrentSkipListSet<String> invalidTokens = new ConcurrentSkipListSet();
    @Inject
    private SimpleApnsClientCache simpleApnsClientCache;
    @Inject
    private ClientInstallationService clientInstallationService;
    @Inject
    private Event<iOSVariantUpdateEvent> variantUpdateEventEvent;

    @Override
    public void sendPushMessage(Variant variant, Collection<String> tokens, UnifiedPushMessage pushMessage, String pushMessageInformationId, NotificationSenderCallback senderCallback) {
        ApnsClient apnsClient;
        String payload;
        if (tokens.isEmpty()) {
            return;
        }
        iOSVariant iOSVariant2 = (iOSVariant)variant;
        try {
            payload = this.createPushPayload(pushMessage.getMessage(), pushMessageInformationId);
        }
        catch (IllegalArgumentException iae) {
            this.logger.info(iae.getMessage(), (Throwable)iae);
            senderCallback.onError("Nothing sent to APNs since the payload is too large");
            return;
        }
        try {
            apnsClient = this.receiveApnsConnection(iOSVariant2);
        }
        catch (IllegalArgumentException iae) {
            this.logger.error(iae.getMessage(), (Throwable)iae);
            senderCallback.onError(String.format("Unable to connect to APNs (%s))", iae.getMessage()));
            return;
        }
        if (apnsClient.isConnected()) {
            senderCallback.onSuccess();
            String defaultApnsTopic = ApnsUtil.readDefaultTopic(iOSVariant2.getCertificate(), iOSVariant2.getPassphrase().toCharArray());
            this.logger.debug("sending payload for all tokens for {} to APNs ({})", (Object)iOSVariant2.getVariantID(), (Object)defaultApnsTopic);
            tokens.forEach(token -> {
                SimpleApnsPushNotification pushNotification = new SimpleApnsPushNotification(token, defaultApnsTopic, payload);
                Future notificationSendFuture = apnsClient.sendNotification((ApnsPushNotification)pushNotification);
                notificationSendFuture.addListener(future -> {
                    if (future.isSuccess()) {
                        this.handlePushNotificationResponsePerToken((PushNotificationResponse<SimpleApnsPushNotification>)((PushNotificationResponse)notificationSendFuture.get()));
                    }
                });
            });
        } else {
            this.logger.error("Unable to send notifications, client is not connected. Removing from cache pool");
            senderCallback.onError("Unable to send notifications, client is not connected");
            this.variantUpdateEventEvent.fire((Object)new iOSVariantUpdateEvent(iOSVariant2));
        }
    }

    private void handlePushNotificationResponsePerToken(PushNotificationResponse<SimpleApnsPushNotification> pushNotificationResponse) {
        String deviceToken = ((SimpleApnsPushNotification)pushNotificationResponse.getPushNotification()).getToken();
        if (pushNotificationResponse.isAccepted()) {
            this.logger.trace("Push notification for '{}' (payload={})", (Object)deviceToken, (Object)((SimpleApnsPushNotification)pushNotificationResponse.getPushNotification()).getPayload());
        } else {
            String rejectReason = pushNotificationResponse.getRejectionReason();
            this.logger.trace("Push Message has been rejected with reason: {}", (Object)rejectReason);
            if (pushNotificationResponse.getTokenInvalidationTimestamp() != null || "BadDeviceToken".equals(rejectReason)) {
                this.logger.info(rejectReason + ", removing token: " + deviceToken);
                this.invalidTokens.add(deviceToken);
            }
        }
    }

    private String createPushPayload(Message message, String pushMessageInformationId) {
        ApnsPayloadBuilder payloadBuilder = new ApnsPayloadBuilder();
        APNs apns = message.getApns();
        if (message.getBadge() >= 0) {
            payloadBuilder.setBadgeNumber(Integer.valueOf(message.getBadge()));
        }
        payloadBuilder.addCustomProperty("aerogear-push-id", (Object)pushMessageInformationId).setAlertBody(message.getAlert()).setSoundFileName(message.getSound()).setAlertTitle(apns.getTitle()).setActionButtonLabel(apns.getAction()).setUrlArguments(apns.getUrlArgs()).setCategoryName(apns.getActionCategory()).setContentAvailable(apns.isContentAvailable());
        Map userData = message.getUserData();
        for (Map.Entry entry : userData.entrySet()) {
            payloadBuilder.addCustomProperty((String)entry.getKey(), entry.getValue());
        }
        return payloadBuilder.buildWithDefaultMaximumLength();
    }

    private ApnsClient receiveApnsConnection(iOSVariant iOSVariant2) {
        return this.simpleApnsClientCache.getApnsClientForVariant(iOSVariant2, () -> {
            ApnsClient apnsClient = this.buildApnsClient(iOSVariant2);
            this.logger.debug("establishing the connection for {}", (Object)iOSVariant2.getVariantID());
            this.connectToDestinations(iOSVariant2, apnsClient);
            apnsClient.getReconnectionFuture().addListener(future -> this.logger.trace("Reconnecting to APNs"));
            return apnsClient;
        });
    }

    private ApnsClient buildApnsClient(iOSVariant iOSVariant2) {
        if (iOSVariant2.getCertificate() != null && iOSVariant2.getPassphrase() != null) {
            try {
                ByteArrayInputStream stream = new ByteArrayInputStream(iOSVariant2.getCertificate());
                ApnsClientBuilder builder = new ApnsClientBuilder();
                builder.setClientCredentials((InputStream)stream, iOSVariant2.getPassphrase());
                if (ProxyConfiguration.hasHttpProxyConfig().booleanValue()) {
                    if (ProxyConfiguration.hasBasicAuth().booleanValue()) {
                        String user = ProxyConfiguration.getProxyUser();
                        String pass = ProxyConfiguration.getProxyPass();
                        builder.setProxyHandlerFactory((ProxyHandlerFactory)new HttpProxyHandlerFactory((SocketAddress)ProxyConfiguration.proxyAddress(), user, pass));
                    } else {
                        builder.setProxyHandlerFactory((ProxyHandlerFactory)new HttpProxyHandlerFactory((SocketAddress)ProxyConfiguration.proxyAddress()));
                    }
                } else if (ProxyConfiguration.hasSocksProxyConfig().booleanValue()) {
                    builder.setProxyHandlerFactory((ProxyHandlerFactory)new Socks5ProxyHandlerFactory((SocketAddress)ProxyConfiguration.socks()));
                }
                ApnsClient apnsClient = builder.build();
                stream.close();
                return apnsClient;
            }
            catch (Exception e) {
                this.logger.error("Error reading certificate", (Throwable)e);
            }
        }
        throw new IllegalArgumentException("Not able to construct APNS client");
    }

    private synchronized void connectToDestinations(iOSVariant iOSVariant2, ApnsClient apnsClient) {
        int apnsPort = 443;
        String apnsHost = iOSVariant2.isProduction() ? "api.push.apple.com" : "api.development.push.apple.com";
        if (customAerogearApnsPushHost != null) {
            apnsHost = customAerogearApnsPushHost;
            if (customAerogearApnsPushPort != null) {
                apnsPort = customAerogearApnsPushPort;
            }
        }
        this.logger.debug("connecting to APNs");
        Future connectFuture = apnsClient.connect(apnsHost, apnsPort);
        try {
            connectFuture.await();
        }
        catch (InterruptedException e) {
            this.logger.error("Error connecting to APNs", (Throwable)e);
        }
    }
}

