/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.sender;

import com.google.android.gcm.server.Message;
import com.google.android.gcm.server.MulticastResult;
import com.google.android.gcm.server.Result;
import io.prometheus.client.Counter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.jboss.aerogear.unifiedpush.api.AndroidVariant;
import org.jboss.aerogear.unifiedpush.api.Installation;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.api.VariantType;
import org.jboss.aerogear.unifiedpush.message.Message;
import org.jboss.aerogear.unifiedpush.message.Priority;
import org.jboss.aerogear.unifiedpush.message.UnifiedPushMessage;
import org.jboss.aerogear.unifiedpush.message.sender.NotificationSenderCallback;
import org.jboss.aerogear.unifiedpush.message.sender.PushNotificationSender;
import org.jboss.aerogear.unifiedpush.message.sender.SenderType;
import org.jboss.aerogear.unifiedpush.message.sender.fcm.ConfigurableFCMSender;
import org.jboss.aerogear.unifiedpush.service.ClientInstallationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SenderType(value=VariantType.ANDROID)
public class FCMPushNotificationSender
implements PushNotificationSender {
    private static final Counter promPrushRequestsAndroid = (Counter)((Counter.Builder)((Counter.Builder)Counter.build().name("aerogear_ups_push_requests_android")).help("Total number of Android push batch requests.")).register();
    private static final Set<String> FCM_ERROR_CODES = new HashSet<String>(Arrays.asList("InvalidRegistration", "NotRegistered", "MismatchSenderId"));
    @Inject
    private ClientInstallationService clientInstallationService;
    private final Logger logger = LoggerFactory.getLogger(FCMPushNotificationSender.class);

    @Override
    public void sendPushMessage(Variant variant, Collection<String> tokens, UnifiedPushMessage pushMessage, String pushMessageInformationId, NotificationSenderCallback callback) {
        if (tokens.isEmpty()) {
            return;
        }
        ArrayList<String> pushTargets = new ArrayList<String>(tokens);
        AndroidVariant androidVariant = (AndroidVariant)variant;
        Message.Builder fcmBuilder = new Message.Builder();
        Message message = pushMessage.getMessage();
        fcmBuilder.addData("alert", message.getAlert());
        fcmBuilder.addData("sound", message.getSound());
        fcmBuilder.addData("badge", String.valueOf(message.getBadge()));
        fcmBuilder.priority(message.getPriority() == Priority.HIGH ? Message.Priority.HIGH : Message.Priority.NORMAL);
        int ttl = pushMessage.getConfig().getTimeToLive();
        if (ttl != -1) {
            fcmBuilder.timeToLive(ttl);
        }
        message.getUserData().keySet().forEach(key -> fcmBuilder.addData(key, String.valueOf(message.getUserData().get(key))));
        fcmBuilder.addData("aerogear-push-id", pushMessageInformationId);
        com.google.android.gcm.server.Message fcmMessage = fcmBuilder.build();
        try {
            this.logger.debug("Sending transformed FCM payload: {}", (Object)fcmMessage);
            ConfigurableFCMSender sender = new ConfigurableFCMSender(androidVariant.getGoogleKey());
            promPrushRequestsAndroid.inc();
            this.processFCM(androidVariant, pushTargets, fcmMessage, sender);
            this.logger.debug("Message batch to FCM has been submitted");
            callback.onSuccess();
        }
        catch (Exception e) {
            callback.onError(String.format("Error sending payload to FCM server: %s", e.getMessage()));
        }
    }

    private void processFCM(AndroidVariant androidVariant, List<String> pushTargets, com.google.android.gcm.server.Message fcmMessage, ConfigurableFCMSender sender) throws IOException {
        if (pushTargets.get(0).startsWith("/topics/")) {
            for (String topic : pushTargets) {
                this.logger.info(String.format("Sent push notification to FCM topic: %s", topic));
                Result result = sender.sendNoRetry(fcmMessage, topic);
                this.logger.trace("Response from FCM topic request: {}", (Object)result);
            }
        } else {
            this.logger.info(String.format("Sent push notification to FCM Server for %d registrationIDs", pushTargets.size()));
            MulticastResult multicastResult = sender.sendNoRetry(fcmMessage, pushTargets);
            this.logger.trace("Response from FCM request: {}", (Object)multicastResult);
            this.cleanupInvalidRegistrationIDsForVariant(androidVariant.getVariantID(), multicastResult, pushTargets);
        }
    }

    private void cleanupInvalidRegistrationIDsForVariant(String variantID, MulticastResult multicastResult, List<String> registrationIDs) {
        List results = multicastResult.getResults();
        HashSet<String> inactiveTokens = new HashSet<String>();
        for (int i = 0; i < results.size(); ++i) {
            String canonicalRegId;
            Result result = (Result)results.get(i);
            String errorCodeName = result.getErrorCodeName();
            if (errorCodeName != null) {
                this.logger.info(String.format("Processing [%s] error code from FCM response, for registration ID: [%s]", errorCodeName, registrationIDs.get(i)));
            }
            if ((canonicalRegId = result.getCanonicalRegistrationId()) != null) {
                Installation installation = this.clientInstallationService.findInstallationForVariantByDeviceToken(variantID, canonicalRegId);
                if (installation != null) {
                    inactiveTokens.add(registrationIDs.get(i));
                    continue;
                }
                installation = this.clientInstallationService.findInstallationForVariantByDeviceToken(variantID, registrationIDs.get(i));
                installation.setDeviceToken(canonicalRegId);
                this.logger.info(String.format("Based on returned canonical id from FCM, updating Android installations with registration id [%s] with new token [%s] ", registrationIDs.get(i), canonicalRegId));
                this.clientInstallationService.updateInstallation(installation);
                continue;
            }
            if (!FCM_ERROR_CODES.contains(errorCodeName)) continue;
            inactiveTokens.add(registrationIDs.get(i));
        }
        if (!inactiveTokens.isEmpty()) {
            this.logger.info(String.format("Based on FCM response data and error codes, deleting %d invalid or duplicated Android installations", inactiveTokens.size()));
            this.clientInstallationService.removeInstallationsForVariantByDeviceTokens(variantID, inactiveTokens);
        }
    }
}

