/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message;

import java.lang.annotation.Annotation;
import java.util.Collection;
import javax.ejb.Stateless;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.aerogear.unifiedpush.api.FlatPushMessageInformation;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.api.VariantType;
import org.jboss.aerogear.unifiedpush.message.UnifiedPushMessage;
import org.jboss.aerogear.unifiedpush.message.holder.MessageHolderWithTokens;
import org.jboss.aerogear.unifiedpush.message.jms.Dequeue;
import org.jboss.aerogear.unifiedpush.message.sender.NotificationSenderCallback;
import org.jboss.aerogear.unifiedpush.message.sender.PushNotificationSender;
import org.jboss.aerogear.unifiedpush.message.sender.SenderTypeLiteral;
import org.jboss.aerogear.unifiedpush.message.util.JmsClient;
import org.jboss.aerogear.unifiedpush.message.util.QueueUtils;
import org.jboss.aerogear.unifiedpush.service.metrics.PrometheusExporter;
import org.jboss.aerogear.unifiedpush.service.metrics.PushMessageMetricsService;
import org.jboss.aerogear.unifiedpush.system.ConfigurationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
public class NotificationDispatcher {
    private static final Logger logger = LoggerFactory.getLogger(NotificationDispatcher.class);
    private static int maxRetries = ConfigurationUtils.tryGetGlobalIntegerProperty((String)"AMQ_MAX_RETRIES", (Integer)3);
    private static int retryTimeout = ConfigurationUtils.tryGetGlobalIntegerProperty((String)"AMQ_BACKOFF_SECONDS", (Integer)10);
    @Inject
    @Any
    private Instance<PushNotificationSender> senders;
    @Inject
    private PushMessageMetricsService pushMessageMetricsService;
    @Inject
    private JmsClient jmsClient;

    public void sendMessagesToPushNetwork(@Observes @Dequeue MessageHolderWithTokens msg) {
        Variant variant = msg.getVariant();
        UnifiedPushMessage unifiedPushMessage = msg.getUnifiedPushMessage();
        Collection<String> deviceTokens = msg.getDeviceTokens();
        logger.info("Received UnifiedPushMessage from JMS queue, will now trigger the Push Notification delivery for the {} variant ({})", (Object)variant.getType().getTypeName(), (Object)variant.getVariantID());
        String deduplicationId = String.format("%s-%s-%d", msg.getPushMessageInformation().getId(), msg.getSerialId(), msg.getRetryCount());
        logger.debug("Receiving message " + deduplicationId);
        try {
            ((PushNotificationSender)this.senders.select(new Annotation[]{new SenderTypeLiteral(variant.getType())}).get()).sendPushMessage(variant, deviceTokens, unifiedPushMessage, msg.getPushMessageInformation().getId(), new SenderServiceCallback(variant, deviceTokens.size(), msg.getPushMessageInformation()));
        }
        catch (Exception everything) {
            logger.error("There was an uncaught exception.\n" + everything.getMessage(), (Throwable)everything);
            try {
                new SenderServiceCallback(variant, deviceTokens.size(), msg.getPushMessageInformation()).onError(everything.getMessage());
                int retryCount = msg.getRetryCount();
                if (retryCount < maxRetries) {
                    MessageHolderWithTokens newMessage = new MessageHolderWithTokens(this.removeErrors(msg.getPushMessageInformation()), msg.getUnifiedPushMessage(), msg.getVariant(), msg.getDeviceTokens(), msg.getSerialId());
                    int i = 0;
                    while (i < msg.getRetryCount() + 1) {
                        newMessage.incrRetryCount();
                        ++i;
                    }
                    VariantType variantType = newMessage.getVariant().getType();
                    deduplicationId = String.format("%s-%s-%d", newMessage.getPushMessageInformation().getId(), newMessage.getSerialId(), newMessage.getRetryCount());
                    logger.debug("Sending retry message " + deduplicationId);
                    this.jmsClient.send(newMessage).withDelayedDelivery((long)retryTimeout * 1000L * (long)newMessage.getRetryCount()).withDuplicateDetectionId(deduplicationId).to(QueueUtils.selectTokenQueue(variantType));
                }
            }
            catch (Exception writeErrorException) {
                logger.error("There was a error writing the exception.\n" + writeErrorException.getMessage(), (Throwable)writeErrorException);
            }
        }
    }

    private FlatPushMessageInformation removeErrors(FlatPushMessageInformation pushMessageInformation) {
        FlatPushMessageInformation info = new FlatPushMessageInformation();
        info.setAppOpenCounter(pushMessageInformation.getAppOpenCounter());
        info.setClientIdentifier(pushMessageInformation.getClientIdentifier());
        info.setFirstOpenDate(pushMessageInformation.getFirstOpenDate());
        info.setId(pushMessageInformation.getId());
        info.setIpAddress(pushMessageInformation.getIpAddress());
        info.setLastOpenDate(pushMessageInformation.getLastOpenDate());
        info.setPushApplicationId(pushMessageInformation.getPushApplicationId());
        info.setRawJsonMessage(pushMessageInformation.getRawJsonMessage());
        info.setSubmitDate(pushMessageInformation.getSubmitDate());
        return info;
    }

    private class SenderServiceCallback
    implements NotificationSenderCallback {
        private final Variant variant;
        private final int tokenSize;
        private final FlatPushMessageInformation pushMessageInformation;

        public SenderServiceCallback(Variant variant, int tokenSize, FlatPushMessageInformation pushMessageInformation) {
            this.variant = variant;
            this.tokenSize = tokenSize;
            this.pushMessageInformation = pushMessageInformation;
        }

        @Override
        public void onSuccess() {
            logger.debug("Sent '{}' message to '{}' devices", (Object)this.variant.getType().getTypeName(), (Object)this.tokenSize);
        }

        @Override
        public void onError(String reason) {
            logger.warn("Error on '{}' delivery: {}", (Object)this.variant.getType().getTypeName(), (Object)reason);
            PrometheusExporter.instance().increaseTotalPushRequestsFail();
            NotificationDispatcher.this.pushMessageMetricsService.appendError(this.pushMessageInformation, this.variant, reason);
        }
    }
}

