/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.aerogear.unifiedpush.api.FlatPushMessageInformation;
import org.jboss.aerogear.unifiedpush.api.PushApplication;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.api.VariantType;
import org.jboss.aerogear.unifiedpush.message.InternalUnifiedPushMessage;
import org.jboss.aerogear.unifiedpush.message.holder.MessageHolderWithVariants;
import org.jboss.aerogear.unifiedpush.message.jms.DispatchToQueue;
import org.jboss.aerogear.unifiedpush.service.GenericVariantService;
import org.jboss.aerogear.unifiedpush.service.metrics.PushMessageMetricsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
public class NotificationRouter {
    private static final Logger logger = LoggerFactory.getLogger(NotificationRouter.class);
    @Inject
    private Instance<GenericVariantService> genericVariantService;
    @Inject
    private PushMessageMetricsService metricsService;
    @Inject
    @DispatchToQueue
    private Event<MessageHolderWithVariants> dispatchVariantMessageEvent;

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void submit(PushApplication pushApplication, InternalUnifiedPushMessage message) {
        logger.debug("Processing send request with '{}' payload", (Object)message.getMessage());
        VariantMap variants = new VariantMap();
        List variantIDs = message.getCriteria().getVariants();
        if (variantIDs != null) {
            variantIDs.forEach(variantID -> {
                Variant variant = ((GenericVariantService)this.genericVariantService.get()).findByVariantID(variantID);
                if (variant != null) {
                    variants.add(variant);
                }
            });
        } else {
            variants.addAll(pushApplication.getVariants());
        }
        String jsonMessageContent = message.toStrippedJsonString();
        if (jsonMessageContent != null && jsonMessageContent.length() >= 4500) {
            jsonMessageContent = message.toMinimizedJsonString();
        }
        FlatPushMessageInformation pushMessageInformation = this.metricsService.storeNewRequestFrom(pushApplication.getPushApplicationID(), jsonMessageContent, message.getIpAddress(), message.getClientIdentifier());
        variants.forEach((variantType, variant) -> {
            logger.info(String.format("Internal dispatching of push message for one %s variant (by %s)", variantType.getTypeName(), message.getClientIdentifier()));
            this.dispatchVariantMessageEvent.fire((Object)new MessageHolderWithVariants(pushMessageInformation, message, (VariantType)variantType, (Collection<Variant>)variant));
        });
    }

    private static class VariantMap
    extends EnumMap<VariantType, List<Variant>> {
        private static final long serialVersionUID = -1942168038908630961L;

        VariantMap() {
            super(VariantType.class);
        }

        void add(Variant variant) {
            ArrayList<Variant> list = (ArrayList<Variant>)this.get(variant.getType());
            if (list == null) {
                list = new ArrayList<Variant>();
                this.put(variant.getType(), list);
            }
            list.add(variant);
        }

        void addAll(Collection<Variant> variants) {
            variants.forEach(this::add);
        }

        int getVariantCount() {
            int count = 0;
            for (Collection variants : this.values()) {
                count += variants.size();
            }
            return count;
        }
    }
}

