/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.cache;

import com.turo.pushy.apns.ApnsClient;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.ejb.Singleton;
import javax.enterprise.event.Observes;
import net.jodah.expiringmap.ExpirationPolicy;
import net.jodah.expiringmap.ExpiringMap;
import org.jboss.aerogear.unifiedpush.api.APNSVariant;
import org.jboss.aerogear.unifiedpush.event.APNSVariantUpdateEvent;
import org.jboss.aerogear.unifiedpush.message.cache.ServiceConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SimpleApnsClientCache {
    private static final Logger logger = LoggerFactory.getLogger(SimpleApnsClientCache.class);
    final ConcurrentMap<String, ApnsClient> apnsClientExpiringMap = ExpiringMap.builder().expiration(12L, TimeUnit.HOURS).expirationPolicy(ExpirationPolicy.ACCESSED).asyncExpirationListener((variantID, apnsClient) -> {
        if (apnsClient != null) {
            logger.info("APNs connection for iOS Variant ({}) was inactive last 12 hours, disconnecting...", variantID);
            Future disconnectFuture = apnsClient.close();
            disconnectFuture.addListener(future -> {
                if (future.isSuccess()) {
                    logger.debug("Disconnected from APNS due to inactive connection for iOS Variant ({})", variantID);
                } else {
                    Throwable t = future.cause();
                    logger.warn(t.getMessage(), t);
                }
            });
        }
    }).build();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApnsClient getApnsClientForVariant(APNSVariant iOSVariant, ServiceConstructor<ApnsClient> constructor) {
        String connectionKey = this.extractConnectionKey(iOSVariant);
        ApnsClient client = (ApnsClient)this.apnsClientExpiringMap.get(connectionKey);
        if (client == null) {
            logger.debug("no cached connection for {}, establishing it", (Object)connectionKey);
            ConcurrentMap<String, ApnsClient> concurrentMap = this.apnsClientExpiringMap;
            synchronized (concurrentMap) {
                client = constructor.construct();
                if (client != null) {
                    this.putApnsClientForVariantID(connectionKey, client);
                }
                return client;
            }
        }
        logger.debug("reusing cached connection for {}", (Object)connectionKey);
        return client;
    }

    public void disconnectOnChange(APNSVariant variant) {
        String connectionKey = this.extractConnectionKey(variant);
        ApnsClient client = (ApnsClient)this.apnsClientExpiringMap.remove(connectionKey);
        logger.debug("Removed client from cache for {}", (Object)variant.getVariantID());
        if (client != null) {
            this.tearDownApnsHttp2Connection(client);
        }
    }

    public void disconnectOnChangeEvent(@Observes APNSVariantUpdateEvent APNSVariantUpdateEvent2) {
        APNSVariant variant = APNSVariantUpdateEvent2.getApnsVariant();
        this.disconnectOnChange(variant);
    }

    private String extractConnectionKey(APNSVariant iOSVariant) {
        StringBuilder sb = new StringBuilder(iOSVariant.getVariantID()).append(iOSVariant.isProduction() ? "-prod" : "-dev");
        return sb.toString();
    }

    private void putApnsClientForVariantID(String variantID, ApnsClient apnsClient) {
        ApnsClient client = this.apnsClientExpiringMap.putIfAbsent(variantID, apnsClient);
        if (client != null) {
            logger.warn("duplicate connection in pool, immediately shutting down the new connection");
            this.tearDownApnsHttp2Connection(apnsClient);
        }
    }

    @PreDestroy
    public void cleanUpConnection() {
        logger.debug("remove all connections before server shutdown");
        for (Map.Entry cachedConnection : this.apnsClientExpiringMap.entrySet()) {
            ApnsClient connection = (ApnsClient)cachedConnection.getValue();
            this.tearDownApnsHttp2Connection(connection);
        }
    }

    private void tearDownApnsHttp2Connection(ApnsClient client) {
        if (client != null) {
            logger.trace("Tearing down connection to APNs for the given client");
            client.close().addListener((GenericFutureListener)new ApnsDisconnectFutureListener());
        }
    }

    private class ApnsDisconnectFutureListener
    implements GenericFutureListener<Future<? super Void>> {
        private ApnsDisconnectFutureListener() {
        }

        public void operationComplete(Future<? super Void> future) throws Exception {
            if (future.isSuccess()) {
                logger.debug("Successfully disconnected connection...");
            } else {
                Throwable t = future.cause();
                logger.warn(t.getMessage(), t);
            }
        }
    }
}

