/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.configuration;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import org.jboss.aerogear.unifiedpush.api.VariantType;
import org.jboss.aerogear.unifiedpush.message.configuration.SenderConfiguration;
import org.jboss.aerogear.unifiedpush.message.sender.SenderType;
import org.jboss.aerogear.unifiedpush.system.ConfigurationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SenderConfigurationProvider {
    private static final Logger logger = LoggerFactory.getLogger(SenderConfigurationProvider.class);

    @Produces
    @ApplicationScoped
    @SenderType(value=VariantType.ANDROID)
    public SenderConfiguration produceAndroidConfiguration() {
        return this.loadConfigurationFor(VariantType.ANDROID, new SenderConfiguration(10, 1000));
    }

    @Produces
    @ApplicationScoped
    @SenderType(value=VariantType.IOS)
    public SenderConfiguration produceIosConfiguration() {
        return this.loadConfigurationFor(VariantType.IOS, new SenderConfiguration(3, 2000));
    }

    @Produces
    @ApplicationScoped
    @SenderType(value=VariantType.IOS_TOKEN)
    public SenderConfiguration produceIosTokenConfiguration() {
        return this.loadConfigurationFor(VariantType.IOS_TOKEN, new SenderConfiguration(3, 2000));
    }

    @Produces
    @ApplicationScoped
    @SenderType(value=VariantType.WEB_PUSH)
    public SenderConfiguration produceWebPushConfiguration() {
        return this.loadConfigurationFor(VariantType.WEB_PUSH, new SenderConfiguration(10, 1000));
    }

    private SenderConfiguration loadConfigurationFor(VariantType type, SenderConfiguration defaultConfiguration) {
        return this.validateAndSanitizeConfiguration(type, new SenderConfiguration(SenderConfigurationProvider.getProperty(type, ConfigurationProperty.batchesToLoad, defaultConfiguration.batchesToLoad(), Integer.class), SenderConfigurationProvider.getProperty(type, ConfigurationProperty.batchSize, defaultConfiguration.batchSize(), Integer.class)));
    }

    private SenderConfiguration validateAndSanitizeConfiguration(VariantType type, SenderConfiguration configuration) {
        switch (type) {
            case ANDROID: {
                if (configuration.batchSize() <= 1000) break;
                logger.warn(String.format("Sender configuration -D%s=%s is invalid: at most 1000 tokens can be submitted to GCM in one batch", SenderConfigurationProvider.getSystemPropertyName(type, ConfigurationProperty.batchSize), configuration.batchSize()));
                configuration.setBatchSize(1000);
                break;
            }
        }
        return configuration;
    }

    private static <T> T getProperty(VariantType type, ConfigurationProperty property, T defaultValue, Class<T> expectedType) {
        String systemPropertyName = SenderConfigurationProvider.getSystemPropertyName(type, property);
        if (expectedType == String.class) {
            return (T)ConfigurationUtils.tryGetGlobalProperty((String)systemPropertyName, (String)((String)defaultValue));
        }
        if (expectedType == Integer.class) {
            return (T)ConfigurationUtils.tryGetGlobalIntegerProperty((String)systemPropertyName, (Integer)((Integer)defaultValue));
        }
        throw new IllegalStateException("Unexpected type: " + expectedType);
    }

    private static String getSystemPropertyName(VariantType type, ConfigurationProperty property) {
        return String.format("aerogear.%s.%s", type.getTypeName(), property.toString());
    }

    private static enum ConfigurationProperty {
        batchesToLoad,
        batchSize;

    }
}

