/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.jms;

import java.io.Serializable;
import javax.annotation.Resource;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import org.jboss.aerogear.unifiedpush.message.exception.MessageDeliveryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJMSMessageProducer {
    private static final Logger logger = LoggerFactory.getLogger(AbstractJMSMessageProducer.class);
    @Resource(mappedName="java:/ConnectionFactory")
    private ConnectionFactory connectionFactory;
    @Resource(mappedName="java:/jms/remoteXA")
    private ConnectionFactory xaConnectionFactory;

    protected void sendNonTransacted(String destination, Serializable message, boolean useTopic) {
        this.send(destination, message, null, null, false, useTopic);
    }

    protected void sendTransacted(String destination, Serializable message, boolean useTopic) {
        this.send(destination, message, null, null, true, useTopic);
    }

    protected void sendNonTransacted(String destination, Serializable message, String propertyName, String propertValue, boolean useTopic) {
        this.send(destination, message, propertyName, propertValue, false, useTopic);
    }

    protected void sendTransacted(String destination, Serializable message, String propertyName, String propertValue, boolean useTopic) {
        this.send(destination, message, propertyName, propertValue, true, useTopic);
    }

    private void send(String destination, Serializable message, String propertyName, String propertValue, boolean transacted, boolean useTopic) {
        Connection connection = null;
        try {
            try {
                connection = transacted ? this.xaConnectionFactory.createConnection() : this.connectionFactory.createConnection();
                Session session = connection.createSession(transacted, 1);
                MessageProducer messageProducer = useTopic ? session.createProducer((Destination)session.createTopic(destination)) : session.createProducer((Destination)session.createQueue(destination));
                logger.debug("Destination is {}", (Object)destination);
                connection.start();
                ObjectMessage objectMessage = session.createObjectMessage(message);
                if (propertyName != null) {
                    objectMessage.setStringProperty(propertyName, propertValue);
                }
                messageProducer.send((Message)objectMessage);
                logger.debug("Sending complete");
            }
            catch (JMSException e) {
                logger.error("Error sending", (Object)e.getMessage(), (Object)e);
                throw new MessageDeliveryException("Failed to queue push message for further processing", e);
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException e) {
                    logger.error("Failed to close JMS connection: ", (Throwable)e);
                }
            }
        }
    }
}

