/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.jms;

import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.aerogear.unifiedpush.api.VariantType;
import org.jboss.aerogear.unifiedpush.message.holder.MessageHolderWithTokens;
import org.jboss.aerogear.unifiedpush.message.jms.AbstractJMSMessageProducer;
import org.jboss.aerogear.unifiedpush.message.jms.DispatchToQueue;
import org.jboss.aerogear.unifiedpush.message.util.JmsClient;
import org.jboss.aerogear.unifiedpush.message.util.QueueUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageHolderWithTokensProducer
extends AbstractJMSMessageProducer {
    private static final Logger logger = LoggerFactory.getLogger(MessageHolderWithTokensProducer.class);
    @Inject
    private JmsClient jmsClient;

    public void queueMessageVariantForProcessing(@Observes @DispatchToQueue MessageHolderWithTokens msg) {
        VariantType variantType = msg.getVariant().getType();
        logger.trace("dispatching payload for {} variant type", (Object)variantType);
        String deduplicationId = String.format("%s-%s", msg.getPushMessageInformation().getId(), msg.getSerialId());
        this.jmsClient.send(msg).withDuplicateDetectionId(deduplicationId).to(QueueUtils.selectTokenQueue(variantType));
    }
}

