/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.sender.apns;

import java.io.ByteArrayInputStream;
import java.security.KeyStore;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.x500.X500Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApnsUtil {
    private static final String KEYSTORE_TYPE = "PKCS12";
    private static final Pattern TOPIC_PATTERN = Pattern.compile(".*UID=([^,]+).*");
    private static final Pattern COMMON_NAME_PATTERN = Pattern.compile("CN=(.*?)\\:");
    private static final List<String> PUSH_SUBJECTS = Arrays.asList("Apple Push Services", "Apple Production IOS Push Services", "Apple Development IOS Push Services");
    private static final Logger LOGGER = LoggerFactory.getLogger(ApnsUtil.class);

    private ApnsUtil() {
    }

    public static String readDefaultTopic(byte[] keystore, char[] password) {
        try {
            KeyStore keyStore = KeyStore.getInstance(KEYSTORE_TYPE);
            keyStore.load(new ByteArrayInputStream(keystore), password);
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                Matcher matcher;
                String alias = aliases.nextElement();
                X509Certificate certificate = (X509Certificate)keyStore.getCertificate(alias);
                X500Principal subjectX500Principal = certificate.getSubjectX500Principal();
                String subject = subjectX500Principal.getName();
                if (subject == null || !(matcher = TOPIC_PATTERN.matcher(subject)).matches()) continue;
                return matcher.group(1);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error parsing .p12 file content", (Throwable)e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkValidity(byte[] keystore, char[] password) {
        try {
            KeyStore keyStore = KeyStore.getInstance(KEYSTORE_TYPE);
            keyStore.load(new ByteArrayInputStream(keystore), password);
            Enumeration<String> aliases = keyStore.aliases();
            block4: while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                X509Certificate certificate = (X509Certificate)keyStore.getCertificate(alias);
                X500Principal subjectX500Principal = certificate.getSubjectX500Principal();
                String subject = subjectX500Principal.getName();
                Matcher matcher = COMMON_NAME_PATTERN.matcher(subject);
                while (matcher.find()) {
                    if (!PUSH_SUBJECTS.contains(matcher.group(1))) continue;
                    try {
                        certificate.checkValidity();
                        continue block4;
                    }
                    catch (CertificateExpiredException | CertificateNotYetValidException e) {
                        LOGGER.error("Provided APNs .p12 file is expired or not yet valid");
                        return false;
                    }
                }
            }
            return ApnsUtil.readDefaultTopic(keystore, password) != null;
        }
        catch (Exception e) {
            LOGGER.error("Error parsing .p12 file content", (Throwable)e);
            return false;
        }
    }
}

