/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.sender.apns;

import com.turo.pushy.apns.ApnsClient;
import com.turo.pushy.apns.ApnsClientBuilder;
import com.turo.pushy.apns.ApnsPushNotification;
import com.turo.pushy.apns.DeliveryPriority;
import com.turo.pushy.apns.PushNotificationResponse;
import com.turo.pushy.apns.PushType;
import com.turo.pushy.apns.auth.ApnsSigningKey;
import com.turo.pushy.apns.proxy.HttpProxyHandlerFactory;
import com.turo.pushy.apns.proxy.ProxyHandlerFactory;
import com.turo.pushy.apns.proxy.Socks5ProxyHandlerFactory;
import com.turo.pushy.apns.util.ApnsPayloadBuilder;
import com.turo.pushy.apns.util.SimpleApnsPushNotification;
import com.turo.pushy.apns.util.concurrent.PushNotificationFuture;
import io.netty.util.concurrent.Future;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.ejb.Stateless;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.net.ssl.SSLException;
import org.jboss.aerogear.unifiedpush.api.APNSVariant;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.api.VariantType;
import org.jboss.aerogear.unifiedpush.api.iOSTokenVariant;
import org.jboss.aerogear.unifiedpush.event.APNSVariantUpdateEvent;
import org.jboss.aerogear.unifiedpush.message.Message;
import org.jboss.aerogear.unifiedpush.message.UnifiedPushMessage;
import org.jboss.aerogear.unifiedpush.message.apns.APNs;
import org.jboss.aerogear.unifiedpush.message.cache.SimpleApnsClientCache;
import org.jboss.aerogear.unifiedpush.message.sender.NotificationSenderCallback;
import org.jboss.aerogear.unifiedpush.message.sender.PushNotificationSender;
import org.jboss.aerogear.unifiedpush.message.sender.SenderType;
import org.jboss.aerogear.unifiedpush.service.ClientInstallationService;
import org.jboss.aerogear.unifiedpush.service.metrics.PrometheusExporter;
import org.jboss.aerogear.unifiedpush.service.proxy.ProxyConfiguration;
import org.jboss.aerogear.unifiedpush.system.ConfigurationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
@SenderType(value=VariantType.IOS_TOKEN)
public class PushyIosTokenSender
implements PushNotificationSender {
    private static final Logger logger = LoggerFactory.getLogger(PushyIosTokenSender.class);
    public static final String CUSTOM_AEROGEAR_APNS_PUSH_HOST = "custom.aerogear.apns.push.host";
    public static final String CUSTOM_AEROGEAR_APNS_PUSH_PORT = "custom.aerogear.apns.push.port";
    private static final String customAerogearApnsPushHost = ConfigurationUtils.tryGetGlobalProperty((String)"custom.aerogear.apns.push.host");
    private static final Integer customAerogearApnsPushPort = ConfigurationUtils.tryGetGlobalIntegerProperty((String)"custom.aerogear.apns.push.port");
    private final ConcurrentSkipListSet<String> invalidTokens = new ConcurrentSkipListSet();
    @Inject
    private SimpleApnsClientCache simpleApnsClientCache;
    @Inject
    private ClientInstallationService clientInstallationService;
    @Inject
    private Event<APNSVariantUpdateEvent> variantUpdateEventEvent;

    @Override
    public void sendPushMessage(Variant variant, Collection<String> tokens, UnifiedPushMessage pushMessage, String pushMessageInformationId, NotificationSenderCallback senderCallback) {
        if (tokens.isEmpty()) {
            return;
        }
        iOSTokenVariant apnsVariant = (iOSTokenVariant)variant;
        this.handleTokenVariant(apnsVariant, senderCallback, pushMessage, pushMessageInformationId, tokens);
    }

    private void handleTokenVariant(iOSTokenVariant iOSTokenVariant2, NotificationSenderCallback senderCallback, UnifiedPushMessage pushMessage, String pushMessageInformationId, Collection<String> tokens) {
        ApnsClient apnsClient;
        String payload;
        try {
            payload = this.createPushPayload(pushMessage.getMessage(), pushMessageInformationId);
        }
        catch (IllegalArgumentException iae) {
            logger.info(iae.getMessage(), (Throwable)iae);
            senderCallback.onError("Nothing sent to APNs since the payload is too large");
            return;
        }
        try {
            apnsClient = this.receiveApnsConnection(iOSTokenVariant2);
        }
        catch (IllegalArgumentException iae) {
            logger.error(iae.getMessage(), (Throwable)iae);
            senderCallback.onError(String.format("Unable to connect to APNs (%s))", iae.getMessage()));
            return;
        }
        if (apnsClient != null) {
            PrometheusExporter.instance().increaseTotalPushIosRequests();
            senderCallback.onSuccess();
            String defaultApnsTopic = iOSTokenVariant2.getBundleId();
            Date expireDate = this.createFutureDateBasedOnTTL(pushMessage.getConfig().getTimeToLive());
            logger.debug("sending payload for all tokens for {} to APNs ({})", (Object)iOSTokenVariant2.getVariantID(), (Object)defaultApnsTopic);
            tokens.forEach(token -> {
                SimpleApnsPushNotification pushNotification = new SimpleApnsPushNotification(token, defaultApnsTopic, payload, expireDate, DeliveryPriority.IMMEDIATE, this.determinePushType(pushMessage.getMessage()), null, null);
                PushNotificationFuture notificationSendFuture = apnsClient.sendNotification((ApnsPushNotification)pushNotification);
                notificationSendFuture.addListener(arg_0 -> this.lambda$1((Future)notificationSendFuture, arg_0));
            });
        } else {
            logger.error("Unable to send notifications, client is not connected. Removing from cache pool");
            senderCallback.onError("Unable to send notifications, client is not connected");
            this.variantUpdateEventEvent.fire((Object)new APNSVariantUpdateEvent((APNSVariant)iOSTokenVariant2));
        }
    }

    private Date createFutureDateBasedOnTTL(int ttl) {
        if (ttl < 0) {
            return new Date(System.currentTimeMillis() + SimpleApnsPushNotification.DEFAULT_EXPIRATION_PERIOD_MILLIS);
        }
        return new Date(System.currentTimeMillis() + (long)ttl * 1000L);
    }

    private PushType determinePushType(Message message) {
        if (!this.isEmpty(message.getAlert()) || !this.isEmpty(message.getSound())) {
            return PushType.ALERT;
        }
        return PushType.BACKGROUND;
    }

    private boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    private void handlePushNotificationResponsePerToken(PushNotificationResponse<SimpleApnsPushNotification> pushNotificationResponse) {
        String deviceToken = ((SimpleApnsPushNotification)pushNotificationResponse.getPushNotification()).getToken();
        if (pushNotificationResponse.isAccepted()) {
            logger.trace("Push notification for '{}' (payload={})", (Object)deviceToken, (Object)((SimpleApnsPushNotification)pushNotificationResponse.getPushNotification()).getPayload());
        } else {
            String rejectReason = pushNotificationResponse.getRejectionReason();
            logger.trace("Push Message has been rejected with reason: {}", (Object)rejectReason);
            if (pushNotificationResponse.getTokenInvalidationTimestamp() != null || "BadDeviceToken".equals(rejectReason)) {
                logger.info(String.valueOf(rejectReason) + ", removing token: " + deviceToken);
                this.invalidTokens.add(deviceToken);
            }
        }
    }

    private String createPushPayload(Message message, String pushMessageInformationId) {
        ApnsPayloadBuilder payloadBuilder = new ApnsPayloadBuilder();
        APNs apns = message.getApns();
        if (message.getBadge() >= 0) {
            payloadBuilder.setBadgeNumber(Integer.valueOf(message.getBadge()));
        }
        payloadBuilder.addCustomProperty("aerogear-push-id", (Object)pushMessageInformationId).setAlertBody(message.getAlert()).setSoundFileName(message.getSound()).setAlertTitle(apns.getTitle()).setActionButtonLabel(apns.getAction()).setUrlArguments(apns.getUrlArgs()).setCategoryName(apns.getActionCategory()).setContentAvailable(apns.isContentAvailable()).setMutableContent(apns.hasMutableContent());
        Map userData = message.getUserData();
        for (Map.Entry entry : userData.entrySet()) {
            payloadBuilder.addCustomProperty((String)entry.getKey(), entry.getValue());
        }
        return payloadBuilder.buildWithDefaultMaximumLength();
    }

    private synchronized ApnsClient receiveApnsConnection(iOSTokenVariant apnsVariant) {
        return this.simpleApnsClientCache.getApnsClientForVariant((APNSVariant)apnsVariant, () -> {
            ApnsClientBuilder builder = new ApnsClientBuilder();
            this.assambleApnsClientBuilderForToken(apnsVariant, builder);
            this.connectToDestinations(apnsVariant, builder);
            logger.debug("establishing the connection for {}", (Object)apnsVariant.getVariantID());
            try {
                logger.debug("connecting to APNs");
                ApnsClient apnsClient = builder.build();
                return apnsClient;
            }
            catch (SSLException e) {
                logger.error("Error connecting to APNs", (Throwable)e);
                return null;
            }
        });
    }

    private void assambleApnsClientBuilderForToken(iOSTokenVariant iOSVariant, ApnsClientBuilder builder) {
        if (iOSVariant.getTeamId() != null && iOSVariant.getKeyId() != null && iOSVariant.getPrivateKey() != null) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (ByteArrayInputStream stream = new ByteArrayInputStream(iOSVariant.getPrivateKey().getBytes());){
                    builder.setSigningKey(ApnsSigningKey.loadFromInputStream((InputStream)stream, (String)iOSVariant.getTeamId(), (String)iOSVariant.getKeyId()));
                    if (ProxyConfiguration.hasHttpProxyConfig().booleanValue()) {
                        if (ProxyConfiguration.hasBasicAuth().booleanValue()) {
                            String user = ProxyConfiguration.getProxyUser();
                            String pass = ProxyConfiguration.getProxyPass();
                            builder.setProxyHandlerFactory((ProxyHandlerFactory)new HttpProxyHandlerFactory((SocketAddress)ProxyConfiguration.proxyAddress(), user, pass));
                        } else {
                            builder.setProxyHandlerFactory((ProxyHandlerFactory)new HttpProxyHandlerFactory((SocketAddress)ProxyConfiguration.proxyAddress()));
                        }
                    } else if (ProxyConfiguration.hasSocksProxyConfig().booleanValue()) {
                        builder.setProxyHandlerFactory((ProxyHandlerFactory)new Socks5ProxyHandlerFactory((SocketAddress)ProxyConfiguration.socks()));
                    }
                    return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                logger.error("Error reading certificate", (Throwable)e);
            }
        }
        throw new IllegalArgumentException("Not able to construct APNS client");
    }

    private void connectToDestinations(iOSTokenVariant iOSVariant, ApnsClientBuilder builder) {
        int apnsPort = 443;
        String apnsHost = iOSVariant.isProduction() ? "api.push.apple.com" : "api.development.push.apple.com";
        if (customAerogearApnsPushHost != null) {
            apnsHost = customAerogearApnsPushHost;
            if (customAerogearApnsPushPort != null) {
                apnsPort = customAerogearApnsPushPort;
            }
        }
        builder.setApnsServer(apnsHost, apnsPort);
    }

    private /* synthetic */ void lambda$1(Future future, Future future2) throws Exception {
        if (future2.isSuccess()) {
            this.handlePushNotificationResponsePerToken((PushNotificationResponse<SimpleApnsPushNotification>)((PushNotificationResponse)future.get()));
        }
    }
}

