/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.token;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import javax.annotation.Resource;
import javax.ejb.EJBContext;
import javax.ejb.Stateless;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.jms.JMSException;
import org.jboss.aerogear.unifiedpush.api.FlatPushMessageInformation;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.api.VariantType;
import org.jboss.aerogear.unifiedpush.dao.ResultStreamException;
import org.jboss.aerogear.unifiedpush.dao.ResultsStream;
import org.jboss.aerogear.unifiedpush.message.Criteria;
import org.jboss.aerogear.unifiedpush.message.UnifiedPushMessage;
import org.jboss.aerogear.unifiedpush.message.configuration.SenderConfiguration;
import org.jboss.aerogear.unifiedpush.message.event.AllBatchesLoadedEvent;
import org.jboss.aerogear.unifiedpush.message.event.BatchLoadedEvent;
import org.jboss.aerogear.unifiedpush.message.exception.MessageDeliveryException;
import org.jboss.aerogear.unifiedpush.message.holder.MessageHolderWithTokens;
import org.jboss.aerogear.unifiedpush.message.holder.MessageHolderWithVariants;
import org.jboss.aerogear.unifiedpush.message.jms.Dequeue;
import org.jboss.aerogear.unifiedpush.message.jms.DispatchToQueue;
import org.jboss.aerogear.unifiedpush.message.sender.SenderTypeLiteral;
import org.jboss.aerogear.unifiedpush.message.token.TokenLoaderUtils;
import org.jboss.aerogear.unifiedpush.service.ClientInstallationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
public class TokenLoader {
    private static final Logger logger = LoggerFactory.getLogger(TokenLoader.class);
    @Inject
    private ClientInstallationService clientInstallationService;
    @Inject
    @DispatchToQueue
    private Event<MessageHolderWithTokens> dispatchTokensEvent;
    @Inject
    @DispatchToQueue
    private Event<MessageHolderWithVariants> nextBatchEvent;
    @Inject
    @DispatchToQueue
    private Event<BatchLoadedEvent> batchLoaded;
    @Inject
    @DispatchToQueue
    private Event<AllBatchesLoadedEvent> allBatchesLoaded;
    @Inject
    @Any
    private Instance<SenderConfiguration> senderConfiguration;
    @Resource
    private EJBContext context;

    public void loadAndQueueTokenBatch(@Observes @Dequeue MessageHolderWithVariants msg) throws IllegalStateException {
        UnifiedPushMessage message = msg.getUnifiedPushMessage();
        VariantType variantType = msg.getVariantType();
        Collection<Variant> variants = msg.getVariants();
        String lastTokenFromPreviousBatch = msg.getLastTokenFromPreviousBatch();
        SenderConfiguration configuration = (SenderConfiguration)this.senderConfiguration.select(new Annotation[]{new SenderTypeLiteral(variantType)}).get();
        FlatPushMessageInformation pushMessageInformation = msg.getPushMessageInformation();
        int serialId = msg.getLastSerialId();
        logger.debug("Received message from queue: {}", (Object)message.getMessage().getAlert());
        Criteria criteria = message.getCriteria();
        List categories = criteria.getCategories();
        List aliases = criteria.getAliases();
        List deviceTypes = criteria.getDeviceTypes();
        logger.info(String.format("Preparing message delivery and loading tokens for the %s 3rd-party Push Network (for %d variants)", variantType, variants.size()));
        for (Variant variant : variants) {
            try {
                ResultsStream tokenStream;
                boolean fcmTopicRequest;
                TreeSet<String> topics = new TreeSet<String>();
                boolean isAndroid = variantType == VariantType.ANDROID;
                int batchesToLoad = configuration.batchesToLoad();
                boolean bl = fcmTopicRequest = isAndroid && TokenLoaderUtils.isFCMTopicRequest(criteria);
                if (fcmTopicRequest) {
                    logger.trace("Processing Firebase Topic request");
                    if (serialId == 0) {
                        topics.addAll(TokenLoaderUtils.extractFCMTopics(criteria, variant.getVariantID()));
                        ++batchesToLoad;
                    }
                    if ((tokenStream = this.clientInstallationService.findAllOldGoogleCloudMessagingDeviceTokenForVariantIDByCriteria(variant.getVariantID(), categories, aliases, deviceTypes, configuration.tokensToLoad(), lastTokenFromPreviousBatch).fetchSize(configuration.batchSize()).executeQuery()).next()) {
                        logger.warn("The application still has old tokens that are not compliant to the InstanceID format");
                    }
                } else {
                    logger.trace("Processing Firebase token request");
                    tokenStream = this.clientInstallationService.findAllDeviceTokenForVariantIDByCriteria(variant.getVariantID(), categories, aliases, deviceTypes, configuration.tokensToLoad(), lastTokenFromPreviousBatch).fetchSize(configuration.batchSize()).executeQuery();
                }
                String lastTokenInBatch = null;
                int tokensLoaded = 0;
                int batchNumber = 0;
                while (batchNumber < batchesToLoad) {
                    ++serialId;
                    TreeSet<String> tokens = new TreeSet<String>();
                    if (isAndroid && batchNumber == 0 && !topics.isEmpty()) {
                        tokens.addAll(topics);
                    } else {
                        int i = 0;
                        while (i < configuration.batchSize() && tokenStream.next()) {
                            lastTokenInBatch = (String)tokenStream.get();
                            tokens.add(lastTokenInBatch);
                            ++tokensLoaded;
                            ++i;
                        }
                    }
                    if (tokens.size() > 0) {
                        if (!this.tryToDispatchTokens(new MessageHolderWithTokens(msg.getPushMessageInformation(), message, variant, tokens, serialId))) {
                            logger.debug(String.format("Failing token loading transaction for batch token #%s for %s variant (%s), since queue is full, will retry...", serialId, variant.getType().getTypeName(), variant.getVariantID()));
                            this.context.setRollbackOnly();
                            return;
                        }
                        logger.info(String.format("Loaded batch #%s, containing %d tokens, for %s variant (%s)", serialId, tokens.size(), variant.getType().getTypeName(), variant.getVariantID()));
                    } else {
                        logger.debug("Ending batch processing: No more tokens for batch #{} available", (Object)serialId);
                        break;
                    }
                    logger.info("Loaded batch #{}, containing {} tokens, for {} variant ({})", new Object[]{serialId, tokens.size(), variant.getType().getTypeName(), variant.getVariantID()});
                    ++batchNumber;
                }
                if (tokensLoaded >= configuration.tokensToLoad()) {
                    logger.debug(String.format("Ending token loading transaction for %s variant (%s)", variant.getType().getTypeName(), variant.getVariantID()));
                    this.nextBatchEvent.fire((Object)new MessageHolderWithVariants(msg.getPushMessageInformation(), message, msg.getVariantType(), variants, serialId, lastTokenInBatch));
                    continue;
                }
                logger.debug("All batches for {} variant were loaded ({})", (Object)variant.getType().getTypeName(), (Object)variant.getVariantID());
                if (tokensLoaded != 0 || lastTokenFromPreviousBatch != null) continue;
                if (fcmTopicRequest) {
                    logger.debug("No legacy(non-InstanceID) tokens found. Just pure GCM topic requests");
                    continue;
                }
                logger.warn("Check your push query: Not a single token was loaded from the DB!");
            }
            catch (ResultStreamException e) {
                logger.error("Failed to load batch of tokens", (Throwable)e);
            }
        }
    }

    private boolean tryToDispatchTokens(MessageHolderWithTokens msg) {
        try {
            this.dispatchTokensEvent.fire((Object)msg);
            return true;
        }
        catch (MessageDeliveryException e) {
            Throwable cause = e.getCause();
            if (TokenLoader.isQueueFullException(cause)) {
                return false;
            }
            throw e;
        }
    }

    private static boolean isQueueFullException(Throwable e) {
        return e instanceof JMSException && e.getCause() != null && "ActiveMQAddressFullException".equals(e.getCause().getClass().getSimpleName());
    }
}

