/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.token;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.jboss.aerogear.unifiedpush.message.Criteria;

public final class TokenLoaderUtils {
    private TokenLoaderUtils() {
    }

    public static Set<String> extractFCMTopics(Criteria criteria, String variantID) {
        TreeSet<String> topics = new TreeSet<String>();
        if (TokenLoaderUtils.isEmptyCriteria(criteria)) {
            topics.add("/topics/" + variantID);
        } else if (TokenLoaderUtils.isCategoryOnlyCriteria(criteria)) {
            topics.addAll(criteria.getCategories().stream().map(category -> "/topics/" + category).collect(Collectors.toList()));
        }
        return topics;
    }

    public static boolean isCategoryOnlyCriteria(Criteria criteria) {
        return TokenLoaderUtils.isEmpty(criteria.getAliases()) && TokenLoaderUtils.isEmpty(criteria.getDeviceTypes()) && !TokenLoaderUtils.isEmpty(criteria.getCategories());
    }

    public static boolean isEmptyCriteria(Criteria criteria) {
        return TokenLoaderUtils.isEmpty(criteria.getAliases()) && TokenLoaderUtils.isEmpty(criteria.getDeviceTypes()) && TokenLoaderUtils.isEmpty(criteria.getCategories());
    }

    public static boolean isFCMTopicRequest(Criteria criteria) {
        return TokenLoaderUtils.isEmptyCriteria(criteria) || TokenLoaderUtils.isCategoryOnlyCriteria(criteria);
    }

    private static boolean isEmpty(List list) {
        return list == null || list.isEmpty();
    }
}

