/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Future;
import javax.ejb.AsyncResult;
import javax.ejb.Asynchronous;
import javax.ejb.Stateless;
import org.jboss.aerogear.unifiedpush.message.HealthNetworkService;
import org.jboss.aerogear.unifiedpush.service.impl.health.HealthDetails;
import org.jboss.aerogear.unifiedpush.service.impl.health.Ping;
import org.jboss.aerogear.unifiedpush.service.impl.health.PushNetwork;
import org.jboss.aerogear.unifiedpush.service.impl.health.Status;
import org.jboss.aerogear.unifiedpush.system.ConfigurationUtils;

@Stateless
public class HealthNetworkServiceImpl
implements HealthNetworkService {
    private static final String customAerogearApnsPushHost = ConfigurationUtils.tryGetGlobalProperty((String)"custom.aerogear.apns.push.host");
    private static final Integer customAerogearApnsPushPort = ConfigurationUtils.tryGetGlobalIntegerProperty((String)"custom.aerogear.apns.push.port");
    private static final String FCM_SEND_ENDPOINT = "https://fcm.googleapis.com/fcm/send".substring("https://".length(), "https://fcm.googleapis.com/fcm/send".indexOf(47, "https://".length()));
    public static final String WNS_SEND_ENDPOINT = "db3.notify.windows.com";
    private static final List<PushNetwork> PUSH_NETWORKS = new ArrayList<PushNetwork>(Arrays.asList(new PushNetwork("Firebase Cloud Messaging", FCM_SEND_ENDPOINT, 443), new PushNetwork("Apple Push Network Sandbox", "api.development.push.apple.com", 443), new PushNetwork("Apple Push Network Production", "api.push.apple.com", 443), new PushNetwork("Windows Push Network", "db3.notify.windows.com", 443)));

    static {
        if (customAerogearApnsPushHost != null) {
            int port = customAerogearApnsPushPort != null ? customAerogearApnsPushPort : 443;
            PUSH_NETWORKS.add(new PushNetwork("APNs Proxy host", customAerogearApnsPushHost, port));
        }
    }

    @Override
    @Asynchronous
    public Future<List<HealthDetails>> networkStatus() {
        ArrayList results = new ArrayList(PUSH_NETWORKS.size());
        PUSH_NETWORKS.forEach(pushNetwork -> {
            HealthDetails details = new HealthDetails();
            details.start();
            details.setDescription(pushNetwork.getName());
            if (Ping.isReachable((String)pushNetwork.getHost(), (int)pushNetwork.getPort())) {
                details.setTestStatus(Status.OK);
                details.setResult("online");
            } else {
                details.setResult(String.format("Network not reachable '%s'", pushNetwork.getName()));
                details.setTestStatus(Status.WARN);
            }
            results.add(details);
            details.stop();
        });
        return new AsyncResult(results);
    }
}

