/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.util;

import org.jboss.aerogear.unifiedpush.api.VariantType;

public class QueueUtils {
    private static final String apnsTokenBatchQueue = "APNsTokenBatchQueue";
    private static final String gcmTokenBatchQueue = "GCMTokenBatchQueue";
    private static final String webTokenBatchQueue = "WebTokenBatchQueue";
    private static final String apnsPushBatchQueue = "APNsPushMessageQueue";
    private static final String gcmPushBatchQueue = "GCMPushMessageQueue";
    private static final String webPushBatchQueue = "WebPushMessageQueue";

    public static String selectTokenQueue(VariantType variantType) {
        switch (variantType) {
            case ANDROID: {
                return gcmTokenBatchQueue;
            }
            case IOS: 
            case IOS_TOKEN: {
                return apnsTokenBatchQueue;
            }
            case WEB_PUSH: {
                return webTokenBatchQueue;
            }
        }
        throw new IllegalStateException("Unknown variant type queue");
    }

    public static String selectPushQueue(VariantType variantType) {
        switch (variantType) {
            case ANDROID: {
                return gcmPushBatchQueue;
            }
            case IOS: 
            case IOS_TOKEN: {
                return apnsPushBatchQueue;
            }
            case WEB_PUSH: {
                return webPushBatchQueue;
            }
        }
        throw new IllegalStateException("Unknown variant type queue");
    }
}

