/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.webpush;

import com.google.gson.Gson;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Base64;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import javax.ejb.Stateless;
import javax.inject.Inject;
import nl.martijndwars.webpush.Notification;
import nl.martijndwars.webpush.PushService;
import org.apache.http.HttpResponse;
import org.jboss.aerogear.unifiedpush.api.FlatPushMessageInformation;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.api.VariantType;
import org.jboss.aerogear.unifiedpush.api.WebPushRegistration;
import org.jboss.aerogear.unifiedpush.api.WebPushVariant;
import org.jboss.aerogear.unifiedpush.dao.FlatPushMessageInformationDao;
import org.jboss.aerogear.unifiedpush.message.NotificationDispatcher;
import org.jboss.aerogear.unifiedpush.message.UnifiedPushMessage;
import org.jboss.aerogear.unifiedpush.message.holder.MessageHolderWithTokens;
import org.jboss.aerogear.unifiedpush.message.sender.NotificationSenderCallback;
import org.jboss.aerogear.unifiedpush.message.sender.PushNotificationSender;
import org.jboss.aerogear.unifiedpush.message.sender.SenderType;
import org.jboss.aerogear.unifiedpush.service.ClientInstallationService;
import org.jboss.aerogear.unifiedpush.utils.KeyUtils;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
@SenderType(value=VariantType.WEB_PUSH)
public class WebPushSender
implements PushNotificationSender {
    private static final Logger logger = LoggerFactory.getLogger(WebPushSender.class);
    private Gson gson = new Gson();
    @Inject
    private ClientInstallationService clientInstallationService;
    @Inject
    private NotificationDispatcher dispatcher;
    @Inject
    private FlatPushMessageInformationDao flatPushMessageInformationDao;

    public WebPushSender() {
    }

    public WebPushSender(FlatPushMessageInformationDao flatPushMessageInformationDao, NotificationDispatcher dispatcher, ClientInstallationService clientInstallationService) {
        this.flatPushMessageInformationDao = flatPushMessageInformationDao;
        this.dispatcher = dispatcher;
        this.clientInstallationService = clientInstallationService;
    }

    @Override
    public void sendPushMessage(Variant variant, Collection<String> tokens, UnifiedPushMessage pushMessage, String pushMessageInformationId, NotificationSenderCallback senderCallback) {
        WebPushVariant webPushVariant = (WebPushVariant)variant;
        String privateKey = webPushVariant.getPrivateKey();
        String publicKey = webPushVariant.getPublicKey();
        String alias = webPushVariant.getAlias();
        PushService webPushService = new PushService();
        try {
            webPushService.setPrivateKey(KeyUtils.loadPrivateKey((String)privateKey));
            webPushService.setPublicKey(KeyUtils.loadPublicKey((String)publicKey));
            webPushService.setSubject(alias);
            HashSet inactiveTokens = new HashSet();
            HashSet<String> rescheduleTokens = new HashSet<String>();
            tokens.forEach(token -> {
                String tokenAsJson = new String(Base64.getDecoder().decode((String)token));
                WebPushRegistration registration = (WebPushRegistration)this.gson.fromJson(tokenAsJson, WebPushRegistration.class);
                try {
                    Notification notification = new Notification(registration.getEndpoint(), KeyUtils.getUserPublicKey((WebPushRegistration)registration), registration.getAuthAsBytes(), this.gson.toJson((Object)pushMessage.getMessage()).getBytes());
                    HttpResponse response = webPushService.send(notification);
                    int responseCode = response.getStatusLine().getStatusCode();
                    String responseReason = response.getStatusLine().getReasonPhrase();
                    switch (response.getStatusLine().getStatusCode()) {
                        case 201: {
                            break;
                        }
                        case 429: {
                            rescheduleTokens.add((String)token);
                            break;
                        }
                        case 404: 
                        case 410: {
                            inactiveTokens.add(token);
                            break;
                        }
                        case 413: {
                            String tooLongMessage = String.format("Request was too long. Message id %s", pushMessageInformationId);
                            logger.error(tooLongMessage);
                            senderCallback.onError(tooLongMessage);
                            break;
                        }
                        case 400: {
                            String badRequestMessage = String.format("Bad request. Message id %s", pushMessageInformationId);
                            logger.error(badRequestMessage);
                            senderCallback.onError(badRequestMessage);
                            break;
                        }
                        default: {
                            String unhandledMessage = String.format("Unknown message response. Was %d with http message %s. Message id %s", responseCode, responseReason, pushMessageInformationId);
                            logger.error(unhandledMessage);
                            senderCallback.onError(unhandledMessage);
                            break;
                        }
                    }
                }
                catch (IOException | InterruptedException | GeneralSecurityException | ExecutionException | JoseException e) {
                    logger.error("Error sending web push message.", e);
                    senderCallback.onError(e.getMessage());
                }
            });
            senderCallback.onSuccess();
            if (!inactiveTokens.isEmpty()) {
                logger.info(String.format("Based on FCM response data and error codes, deleting %d invalid or duplicated Android installations", inactiveTokens.size()));
                this.clientInstallationService.removeInstallationsForVariantByDeviceTokens(variant.getVariantID(), inactiveTokens);
            }
            if (!rescheduleTokens.isEmpty()) {
                FlatPushMessageInformation flatPushMessageInformation = this.removeErrors((FlatPushMessageInformation)this.flatPushMessageInformationDao.find((Object)pushMessageInformationId));
                MessageHolderWithTokens newMessage = new MessageHolderWithTokens(flatPushMessageInformation, pushMessage, variant, rescheduleTokens, 0);
                newMessage.incrRetryCount();
                this.dispatcher.sendMessagesToPushNetwork(newMessage);
            }
        }
        catch (GeneralSecurityException e) {
            logger.error("Could not load VAPID keys.", (Throwable)e);
            senderCallback.onError(e.getMessage());
        }
    }

    private FlatPushMessageInformation removeErrors(FlatPushMessageInformation pushMessageInformation) {
        FlatPushMessageInformation info = new FlatPushMessageInformation();
        info.setAppOpenCounter(pushMessageInformation.getAppOpenCounter());
        info.setClientIdentifier(pushMessageInformation.getClientIdentifier());
        info.setFirstOpenDate(pushMessageInformation.getFirstOpenDate());
        info.setId(pushMessageInformation.getId());
        info.setIpAddress(pushMessageInformation.getIpAddress());
        info.setLastOpenDate(pushMessageInformation.getLastOpenDate());
        info.setPushApplicationId(pushMessageInformation.getPushApplicationId());
        info.setRawJsonMessage(pushMessageInformation.getRawJsonMessage());
        info.setSubmitDate(pushMessageInformation.getSubmitDate());
        return info;
    }
}

