/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message;

import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Asynchronous;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.jboss.aerogear.unifiedpush.api.AndroidVariant;
import org.jboss.aerogear.unifiedpush.api.ChromePackagedAppVariant;
import org.jboss.aerogear.unifiedpush.api.PushApplication;
import org.jboss.aerogear.unifiedpush.api.PushMessageInformation;
import org.jboss.aerogear.unifiedpush.api.SimplePushVariant;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.api.VariantMetricInformation;
import org.jboss.aerogear.unifiedpush.api.iOSVariant;
import org.jboss.aerogear.unifiedpush.message.SendCriteria;
import org.jboss.aerogear.unifiedpush.message.SenderService;
import org.jboss.aerogear.unifiedpush.message.UnifiedPushMessage;
import org.jboss.aerogear.unifiedpush.message.sender.APNsPushNotificationSender;
import org.jboss.aerogear.unifiedpush.message.sender.GCMForChromePushNotificationSender;
import org.jboss.aerogear.unifiedpush.message.sender.GCMPushNotificationSender;
import org.jboss.aerogear.unifiedpush.message.sender.NotificationSenderCallback;
import org.jboss.aerogear.unifiedpush.message.sender.SimplePushNotificationSender;
import org.jboss.aerogear.unifiedpush.service.ClientInstallationService;
import org.jboss.aerogear.unifiedpush.service.GenericVariantService;
import org.jboss.aerogear.unifiedpush.service.metrics.PushMessageMetricsService;

@Stateless
@Asynchronous
public class SenderServiceImpl
implements SenderService {
    private final Logger logger = Logger.getLogger(SenderServiceImpl.class.getName());
    private final SimplePushNotificationSender simplePushSender = new SimplePushNotificationSender();
    private final GCMForChromePushNotificationSender gcmForChromePushNotificationSender = new GCMForChromePushNotificationSender();
    @Inject
    private GCMPushNotificationSender gcmSender;
    @Inject
    private APNsPushNotificationSender apnsSender;
    @Inject
    private ClientInstallationService clientInstallationService;
    @Inject
    private GenericVariantService genericVariantService;
    @Inject
    private PushMessageMetricsService metricsService;

    @Override
    @Asynchronous
    public void send(PushApplication pushApplication, UnifiedPushMessage message) {
        this.logger.log(Level.INFO, "Processing send request with '" + message.toString() + "' payload");
        final PushMessageInformation pushMessageInformation = this.metricsService.storeNewRequestFrom(pushApplication.getPushApplicationID(), message.toJsonString(), message.getIpAddress(), message.getClientIdentifier());
        HashSet<iOSVariant> iOSVariants = new HashSet<iOSVariant>();
        HashSet<AndroidVariant> androidVariants = new HashSet<AndroidVariant>();
        HashSet<SimplePushVariant> simplePushVariants = new HashSet<SimplePushVariant>();
        HashSet<ChromePackagedAppVariant> chromePackagedAppVariants = new HashSet<ChromePackagedAppVariant>();
        SendCriteria criteria = message.getSendCriteria();
        List<String> variantIDs = criteria.getVariants();
        if (variantIDs != null) {
            for (String variantID : variantIDs) {
                Variant variant = this.genericVariantService.findByVariantID(variantID);
                if (variant == null) continue;
                switch (variant.getType()) {
                    case ANDROID: {
                        androidVariants.add((AndroidVariant)variant);
                        break;
                    }
                    case IOS: {
                        iOSVariants.add((iOSVariant)variant);
                        break;
                    }
                    case SIMPLE_PUSH: {
                        simplePushVariants.add((SimplePushVariant)variant);
                        break;
                    }
                    case CHROME_PACKAGED_APP: {
                        chromePackagedAppVariants.add((ChromePackagedAppVariant)variant);
                    }
                }
            }
        } else {
            androidVariants.addAll(pushApplication.getAndroidVariants());
            iOSVariants.addAll(pushApplication.getIOSVariants());
            simplePushVariants.addAll(pushApplication.getSimplePushVariants());
            chromePackagedAppVariants.addAll(pushApplication.getChromePackagedAppVariants());
        }
        List<String> categories = criteria.getCategories();
        List<String> aliases = criteria.getAliases();
        List<String> deviceTypes = criteria.getDeviceTypes();
        if (message.getData() != null) {
            for (final iOSVariant iOSVariant2 : iOSVariants) {
                final List tokenPerVariant = this.clientInstallationService.findAllDeviceTokenForVariantIDByCriteria(iOSVariant2.getVariantID(), categories, aliases, deviceTypes);
                this.apnsSender.sendPushMessage((Variant)iOSVariant2, tokenPerVariant, message, new NotificationSenderCallback(){

                    @Override
                    public void onSuccess() {
                        SenderServiceImpl.this.logger.log(Level.FINE, "Sent APNs message to '" + tokenPerVariant.size() + "' devices");
                        SenderServiceImpl.this.updateStatusOfPushMessageInformation(pushMessageInformation, iOSVariant2.getVariantID(), tokenPerVariant.size(), Boolean.TRUE);
                    }

                    @Override
                    public void onError() {
                        SenderServiceImpl.this.logger.log(Level.WARNING, "Error on APNs delivery");
                        SenderServiceImpl.this.updateStatusOfPushMessageInformation(pushMessageInformation, iOSVariant2.getVariantID(), tokenPerVariant.size(), Boolean.FALSE);
                    }
                });
            }
            for (final AndroidVariant androidVariant : androidVariants) {
                final List androidTokenPerVariant = this.clientInstallationService.findAllDeviceTokenForVariantIDByCriteria(androidVariant.getVariantID(), categories, aliases, deviceTypes);
                this.gcmSender.sendPushMessage((Variant)androidVariant, androidTokenPerVariant, message, new NotificationSenderCallback(){

                    @Override
                    public void onSuccess() {
                        SenderServiceImpl.this.logger.log(Level.FINE, "Sent GCM-Android message to '" + androidTokenPerVariant.size() + "' devices");
                        SenderServiceImpl.this.updateStatusOfPushMessageInformation(pushMessageInformation, androidVariant.getVariantID(), androidTokenPerVariant.size(), Boolean.TRUE);
                    }

                    @Override
                    public void onError() {
                        SenderServiceImpl.this.logger.log(Level.WARNING, "Error on GCM-Android delivery");
                        SenderServiceImpl.this.updateStatusOfPushMessageInformation(pushMessageInformation, androidVariant.getVariantID(), androidTokenPerVariant.size(), Boolean.FALSE);
                    }
                });
            }
            for (final ChromePackagedAppVariant chromePackagedAppVariant : chromePackagedAppVariants) {
                final List chromePackagedAppTokenPerVariant = this.clientInstallationService.findAllDeviceTokenForVariantIDByCriteria(chromePackagedAppVariant.getVariantID(), categories, aliases, deviceTypes);
                this.logger.log(Level.FINE, "Sending Chrome/GCM message to '" + chromePackagedAppTokenPerVariant.size() + "' devices");
                this.gcmForChromePushNotificationSender.sendPushMessage((Variant)chromePackagedAppVariant, chromePackagedAppTokenPerVariant, message, new NotificationSenderCallback(){

                    @Override
                    public void onSuccess() {
                        SenderServiceImpl.this.logger.log(Level.FINE, "Sent GCM-Chrome message to '" + chromePackagedAppTokenPerVariant.size() + "' devices");
                        SenderServiceImpl.this.updateStatusOfPushMessageInformation(pushMessageInformation, chromePackagedAppVariant.getVariantID(), chromePackagedAppTokenPerVariant.size(), Boolean.TRUE);
                    }

                    @Override
                    public void onError() {
                        SenderServiceImpl.this.logger.log(Level.WARNING, "Error on GCM-Chrome  delivery");
                        SenderServiceImpl.this.updateStatusOfPushMessageInformation(pushMessageInformation, chromePackagedAppVariant.getVariantID(), chromePackagedAppTokenPerVariant.size(), Boolean.FALSE);
                    }
                });
            }
        }
        for (final SimplePushVariant simplePushVariant : simplePushVariants) {
            final List pushEndpointURLsPerCategory = this.clientInstallationService.findAllSimplePushEndpointURLsForVariantIDByCriteria(simplePushVariant.getVariantID(), categories, aliases, deviceTypes);
            this.simplePushSender.sendPushMessage((Variant)simplePushVariant, pushEndpointURLsPerCategory, message, new NotificationSenderCallback(){

                @Override
                public void onSuccess() {
                    SenderServiceImpl.this.logger.log(Level.FINE, "Sent SimplePush message to '" + pushEndpointURLsPerCategory.size() + "' devices");
                    SenderServiceImpl.this.updateStatusOfPushMessageInformation(pushMessageInformation, simplePushVariant.getVariantID(), pushEndpointURLsPerCategory.size(), Boolean.TRUE);
                }

                @Override
                public void onError() {
                    SenderServiceImpl.this.logger.log(Level.WARNING, "Error on SimplePush delivery");
                    SenderServiceImpl.this.updateStatusOfPushMessageInformation(pushMessageInformation, simplePushVariant.getVariantID(), pushEndpointURLsPerCategory.size(), Boolean.FALSE);
                }
            });
        }
    }

    private void updateStatusOfPushMessageInformation(PushMessageInformation pushMessageInformation, String variantID, int receives, Boolean deliveryStatus) {
        VariantMetricInformation variantMetricInformation = new VariantMetricInformation();
        variantMetricInformation.setVariantID(variantID);
        variantMetricInformation.setReceivers((long)receives);
        variantMetricInformation.setDeliveryStatus(deliveryStatus);
        pushMessageInformation.getVariantInformations().add(variantMetricInformation);
        this.metricsService.updatePushMessageInformation(pushMessageInformation);
    }
}

