/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Asynchronous;
import javax.ejb.Stateless;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.aerogear.unifiedpush.api.PushApplication;
import org.jboss.aerogear.unifiedpush.api.PushMessageInformation;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.api.VariantMetricInformation;
import org.jboss.aerogear.unifiedpush.message.SendCriteria;
import org.jboss.aerogear.unifiedpush.message.SenderService;
import org.jboss.aerogear.unifiedpush.message.UnifiedPushMessage;
import org.jboss.aerogear.unifiedpush.message.sender.NotificationSenderCallback;
import org.jboss.aerogear.unifiedpush.message.sender.PushNotificationSender;
import org.jboss.aerogear.unifiedpush.message.sender.SenderTypeLiteral;
import org.jboss.aerogear.unifiedpush.service.ClientInstallationService;
import org.jboss.aerogear.unifiedpush.service.GenericVariantService;
import org.jboss.aerogear.unifiedpush.service.metrics.PushMessageMetricsService;

@Stateless
@Asynchronous
public class SenderServiceImpl
implements SenderService {
    private final Logger logger = Logger.getLogger(SenderServiceImpl.class.getName());
    @Inject
    @Any
    private Instance<PushNotificationSender> senders;
    @Inject
    private ClientInstallationService clientInstallationService;
    @Inject
    private GenericVariantService genericVariantService;
    @Inject
    private PushMessageMetricsService metricsService;

    @Override
    @Asynchronous
    public void send(PushApplication pushApplication, UnifiedPushMessage message) {
        this.logger.log(Level.INFO, "Processing send request with '" + message.toString() + "' payload");
        final PushMessageInformation pushMessageInformation = this.metricsService.storeNewRequestFrom(pushApplication.getPushApplicationID(), message.toJsonString(), message.getIpAddress(), message.getClientIdentifier());
        HashSet<Variant> variants = new HashSet<Variant>();
        SendCriteria criteria = message.getSendCriteria();
        List<String> variantIDs = criteria.getVariants();
        if (variantIDs != null) {
            for (String variantID : variantIDs) {
                Variant variant = this.genericVariantService.findByVariantID(variantID);
                if (variant == null) continue;
                variants.add(variant);
            }
        } else {
            variants.addAll(pushApplication.getVariants());
        }
        List<String> categories = criteria.getCategories();
        List<String> aliases = criteria.getAliases();
        List<String> deviceTypes = criteria.getDeviceTypes();
        if (message.getData() != null) {
            for (final Variant variant : variants) {
                List tokenPerVariant = this.clientInstallationService.findAllDeviceTokenForVariantIDByCriteria(variant.getVariantID(), categories, aliases, deviceTypes);
                final int tokenSize = tokenPerVariant.size();
                ((PushNotificationSender)this.senders.select(new Annotation[]{new SenderTypeLiteral(variant.getClass())}).get()).sendPushMessage(variant, tokenPerVariant, message, new NotificationSenderCallback(){

                    @Override
                    public void onSuccess() {
                        SenderServiceImpl.this.logger.log(Level.FINE, String.format("Sent '%s' message to '%d' devices", variant.getType().getTypeName(), tokenSize));
                        SenderServiceImpl.this.updateStatusOfPushMessageInformation(pushMessageInformation, variant.getVariantID(), tokenSize, Boolean.TRUE);
                    }

                    @Override
                    public void onError(String reason) {
                        SenderServiceImpl.this.logger.log(Level.WARNING, String.format("Error on '%s' delivery", variant.getType().getTypeName()));
                        SenderServiceImpl.this.updateStatusOfPushMessageInformation(pushMessageInformation, variant.getVariantID(), tokenSize, Boolean.FALSE, reason);
                    }
                });
            }
        }
    }

    private void updateStatusOfPushMessageInformation(PushMessageInformation pushMessageInformation, String variantID, int receives, Boolean deliveryStatus) {
        this.updateStatusOfPushMessageInformation(pushMessageInformation, variantID, receives, deliveryStatus, null);
    }

    private void updateStatusOfPushMessageInformation(PushMessageInformation pushMessageInformation, String variantID, int receives, Boolean deliveryStatus, String reason) {
        VariantMetricInformation variantMetricInformation = new VariantMetricInformation();
        variantMetricInformation.setVariantID(variantID);
        variantMetricInformation.setReceivers((long)receives);
        variantMetricInformation.setDeliveryStatus(deliveryStatus);
        variantMetricInformation.setReason(reason);
        pushMessageInformation.getVariantInformations().add(variantMetricInformation);
        this.metricsService.updatePushMessageInformation(pushMessageInformation);
    }
}

