/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.sender;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.Response;
import org.jboss.aerogear.unifiedpush.api.SimplePushVariant;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.message.UnifiedPushMessage;
import org.jboss.aerogear.unifiedpush.message.sender.NotificationSenderCallback;
import org.jboss.aerogear.unifiedpush.message.sender.PushNotificationSender;
import org.jboss.aerogear.unifiedpush.message.sender.SenderType;

@SenderType(value=SimplePushVariant.class)
public class SimplePushNotificationSender
implements PushNotificationSender {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final Logger logger = Logger.getLogger(SimplePushNotificationSender.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendPushMessage(Variant variant, Collection<String> tokens, UnifiedPushMessage pushMessage, NotificationSenderCallback callback) {
        String payload = pushMessage.getSimplePush();
        if (payload == null) {
            payload = System.currentTimeMillis() + "";
        }
        for (String clientURL : tokens) {
            HttpURLConnection conn = null;
            try {
                this.logger.log(Level.FINEST, "Sending out SimplePush payload: " + payload);
                conn = this.put(clientURL, payload);
                int simplePushStatusCode = conn.getResponseCode();
                this.logger.log(Level.INFO, "SimplePush Status: " + simplePushStatusCode);
                if (Response.Status.OK.getStatusCode() == simplePushStatusCode) {
                    callback.onSuccess();
                    continue;
                }
                this.logger.log(Level.SEVERE, "Error during PUT execution to SimplePush Network, status code was: " + simplePushStatusCode);
                callback.onError("Error delivering SimplePush payload");
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "Error during PUT execution to SimplePush Network", e);
                callback.onError("Error delivering SimplePush payload");
            }
            finally {
                if (conn == null) continue;
                conn.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpURLConnection put(String url, String body) throws IOException {
        if (url == null || body == null) {
            throw new IllegalArgumentException("arguments cannot be null");
        }
        byte[] bytes = body.getBytes(UTF_8);
        HttpURLConnection conn = this.getConnection(url);
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setFixedLengthStreamingMode(bytes.length);
        conn.setRequestProperty("Accept", "application/x-www-form-urlencoded");
        conn.setRequestMethod("PUT");
        OutputStream out = null;
        try {
            out = conn.getOutputStream();
            out.write(bytes);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return conn;
    }

    protected HttpURLConnection getConnection(String url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        return conn;
    }
}

