/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.sender;

import com.notnoop.apns.APNS;
import com.notnoop.apns.ApnsDelegate;
import com.notnoop.apns.ApnsDelegateAdapter;
import com.notnoop.apns.ApnsNotification;
import com.notnoop.apns.ApnsService;
import com.notnoop.apns.ApnsServiceBuilder;
import com.notnoop.apns.PayloadBuilder;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.api.iOSVariant;
import org.jboss.aerogear.unifiedpush.message.UnifiedPushMessage;
import org.jboss.aerogear.unifiedpush.message.sender.NotificationSenderCallback;
import org.jboss.aerogear.unifiedpush.message.sender.PushNotificationSender;
import org.jboss.aerogear.unifiedpush.message.sender.SenderType;
import org.jboss.aerogear.unifiedpush.service.ClientInstallationService;

@SenderType(value=iOSVariant.class)
public class APNsPushNotificationSender
implements PushNotificationSender {
    private final Logger logger = Logger.getLogger(APNsPushNotificationSender.class.getName());
    @Inject
    private ClientInstallationService clientInstallationService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void sendPushMessage(Variant variant, Collection<String> tokens, UnifiedPushMessage pushMessage, NotificationSenderCallback callback) {
        if (tokens.isEmpty()) {
            return;
        }
        iOSVariant iOSVariant2 = (iOSVariant)variant;
        PayloadBuilder builder = APNS.newPayload().alertBody(pushMessage.getAlert()).badge(pushMessage.getBadge()).sound(pushMessage.getSound()).category(pushMessage.getActionCategory());
        if (pushMessage.isContentAvailable()) {
            builder = builder.instantDeliveryOrSilentNotification();
        }
        if ((builder = builder.customFields(pushMessage.getData())).isTooLong()) {
            this.logger.log(Level.WARNING, "Nothing sent to APNs since the payload is too large");
            callback.onError("message too long for APNs");
            return;
        }
        String apnsMessage = builder.build();
        ApnsService service = this.buildApnsService(iOSVariant2, callback);
        if (service != null) {
            try {
                this.logger.log(Level.FINE, "Sending transformed APNs payload: " + apnsMessage);
                service.start();
                Date expireDate = this.createFutureDateBasedOnTTL(pushMessage.getTimeToLive());
                service.push(tokens, apnsMessage, expireDate);
                this.logger.log(Level.INFO, "Message to APNs has been submitted");
                Set<String> inactiveTokens = service.getInactiveDevices().keySet();
                Set<String> transformedTokens = this.lowerCaseAllTokens(inactiveTokens);
                if (transformedTokens.isEmpty()) return;
                this.logger.log(Level.INFO, "Deleting '" + inactiveTokens.size() + "' invalid iOS installations");
                this.clientInstallationService.removeInstallationsForVariantByDeviceTokens(iOSVariant2.getVariantID(), transformedTokens);
                return;
            }
            catch (RuntimeException e) {
                this.logger.log(Level.SEVERE, "Error sending messages to APN server", e);
                callback.onError("Error sending messages to APN server");
                return;
            }
            finally {
                service.stop();
            }
        } else {
            this.logger.log(Level.SEVERE, "No certificate was found. Could not send messages to APNs");
            callback.onError("No certificate for APNs was found");
        }
    }

    private Date createFutureDateBasedOnTTL(int ttl) {
        if (ttl == -1) {
            return new Date(System.currentTimeMillis() + 2147483647000L);
        }
        return new Date(System.currentTimeMillis() + (long)ttl);
    }

    private Set<String> lowerCaseAllTokens(Set<String> inactiveTokens) {
        HashSet<String> lowerCaseTokens = new HashSet<String>();
        for (String token : inactiveTokens) {
            lowerCaseTokens.add(token.toLowerCase());
        }
        return lowerCaseTokens;
    }

    private ApnsService buildApnsService(iOSVariant iOSVariant2, final NotificationSenderCallback notificationSenderCallback) {
        if (iOSVariant2.getCertificate() != null && iOSVariant2.getPassphrase() != null) {
            ApnsServiceBuilder builder = APNS.newService().withNoErrorDetection();
            builder.withDelegate((ApnsDelegate)new ApnsDelegateAdapter(){

                public void messageSent(ApnsNotification message, boolean resent) {
                    notificationSenderCallback.onSuccess();
                }

                public void messageSendFailed(ApnsNotification message, Throwable e) {
                    APNsPushNotificationSender.this.logger.log(Level.SEVERE, "Error sending payload to APNs server", e);
                    notificationSenderCallback.onError("Error sending payload to APNs server");
                }
            });
            try {
                ByteArrayInputStream stream = new ByteArrayInputStream(iOSVariant2.getCertificate());
                builder.withCert((InputStream)stream, iOSVariant2.getPassphrase());
                stream.close();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Error reading certificate", e);
                return null;
            }
            if (iOSVariant2.isProduction()) {
                builder.withProductionDestination();
            } else {
                builder.withSandboxDestination();
            }
            return builder.build();
        }
        return null;
    }
}

