/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message;

import java.util.Iterator;
import java.util.Map;
import org.jboss.aerogear.unifiedpush.message.SendCriteria;

public class UnifiedPushMessage {
    private String ipAddress;
    private String clientIdentifier;
    private final SendCriteria criteria;
    private final String simplePush;
    private final String actionCategory;
    private final String alert;
    private final String sound;
    private final boolean contentAvailable;
    private final int badge;
    private final int timeToLive;
    private final Map<String, Object> data;

    public UnifiedPushMessage(Map<String, Object> data) {
        this.criteria = new SendCriteria(data);
        this.data = (Map)data.remove("message");
        if (this.data != null) {
            this.alert = (String)this.data.remove("alert");
            this.sound = (String)this.data.remove("sound");
            this.actionCategory = (String)this.data.remove("action-category");
            Boolean contentValue = (Boolean)this.data.remove("content-available");
            this.contentAvailable = contentValue == null ? false : contentValue;
            Integer badgeVal = (Integer)this.data.remove("badge");
            this.badge = badgeVal == null ? -1 : badgeVal;
        } else {
            this.alert = null;
            this.sound = null;
            this.actionCategory = null;
            this.badge = -1;
            this.contentAvailable = false;
        }
        Integer timeToLiveValue = (Integer)data.remove("ttl");
        this.timeToLive = timeToLiveValue == null ? -1 : timeToLiveValue;
        this.simplePush = (String)data.remove("simple-push");
    }

    public SendCriteria getSendCriteria() {
        return this.criteria;
    }

    public String getSimplePush() {
        return this.simplePush;
    }

    public String getAlert() {
        return this.alert;
    }

    public String getActionCategory() {
        return this.actionCategory;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public String getSound() {
        return this.sound;
    }

    public int getBadge() {
        return this.badge;
    }

    public boolean isContentAvailable() {
        return this.contentAvailable;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getClientIdentifier() {
        return this.clientIdentifier;
    }

    public void setClientIdentifier(String clientIdentifier) {
        this.clientIdentifier = clientIdentifier;
    }

    public String toJsonString() {
        return "{\"ipAddress\":\"" + this.ipAddress + "\"," + "\"clientIdentifier\":\"" + this.clientIdentifier + "\"," + "\"simplePush\":\"" + this.simplePush + "\"," + "\"alert\":\"" + this.alert + "\"," + "\"action-category\":\"" + this.actionCategory + "\"," + "\"sound\":\"" + this.sound + "\"," + "\"contentAvailable\":" + this.contentAvailable + "," + "\"badge\":" + this.badge + "," + "\"timeToLive\":" + this.timeToLive + "," + "\"data\":" + this.toJson(this.data) + "}";
    }

    private String toJson(Map<String, Object> map) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (map != null) {
            Iterator<Map.Entry<String, Object>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                sb.append("\"").append(entry.getKey()).append("\":\"").append(entry.getValue()).append("\"");
                if (!iterator.hasNext()) continue;
                sb.append(",");
            }
        }
        sb.append("}");
        return sb.toString();
    }

    public String toString() {
        return "[alert=" + this.alert + ", data=" + this.data + ", criteria=" + this.criteria + ", sound=" + this.sound + ", action-category=" + this.actionCategory + ", badge=" + this.badge + ", time-to-live=" + this.timeToLive + ", simplePush=" + this.simplePush + ", content-available=" + this.contentAvailable + "]";
    }
}

