/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.sender;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jboss.aerogear.unifiedpush.api.ChromePackagedAppVariant;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.message.UnifiedPushMessage;
import org.jboss.aerogear.unifiedpush.message.helper.ChromePackagedAppTokenCache;
import org.jboss.aerogear.unifiedpush.message.sender.NotificationSenderCallback;
import org.jboss.aerogear.unifiedpush.message.sender.PushNotificationSender;
import org.jboss.aerogear.unifiedpush.message.sender.SenderType;
import org.jboss.aerogear.unifiedpush.utils.AeroGearLogger;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

@SenderType(value=ChromePackagedAppVariant.class)
public class GCMForChromePushNotificationSender
implements PushNotificationSender {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final String MESSAGE_URL = "https://www.googleapis.com/gcm_for_chrome/v1/messages";
    private static final String ACCESS_TOKEN_URL = "https://accounts.google.com/o/oauth2/token";
    private final AeroGearLogger logger = AeroGearLogger.getInstance(GCMForChromePushNotificationSender.class);
    private Map<String, ChromePackagedAppTokenCache> accessTokenMap = new HashMap<String, ChromePackagedAppTokenCache>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendPushMessage(Variant variant, Collection<String> tokens, UnifiedPushMessage pushMessage, NotificationSenderCallback callback) {
        if (tokens.isEmpty()) {
            return;
        }
        ChromePackagedAppVariant chromePackagedAppVariant = (ChromePackagedAppVariant)variant;
        String accessToken = this.fetchAccessToken(chromePackagedAppVariant);
        for (String channelID : tokens) {
            HttpURLConnection conn = null;
            try {
                String clientURL = MESSAGE_URL;
                conn = this.post(MESSAGE_URL, "{'channelId': '" + channelID + "', 'subchannelId': '0', 'payload': '" + pushMessage.getAlert() + "'}", accessToken);
                int chromePackagedAppStatusCode = conn.getResponseCode();
                if (chromePackagedAppStatusCode < 400) {
                    callback.onSuccess();
                    continue;
                }
                this.logger.severe("Error during Post execution to GCM for Chrome Network, status code was: " + chromePackagedAppStatusCode);
                callback.onError("Error delivering GCM/Chrome payload");
            }
            catch (IOException e) {
                this.logger.severe("Error during Post execution to GCM for Chrome Network", (Throwable)e);
                callback.onError("Error delivering GCM/Chrome payload");
            }
            finally {
                if (conn == null) continue;
                conn.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpURLConnection post(String url, String body, String accessToken) throws IOException {
        if (url == null || body == null) {
            throw new IllegalArgumentException("arguments cannot be null");
        }
        byte[] bytes = body.getBytes(UTF_8);
        HttpURLConnection conn = this.getConnection(url);
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setFixedLengthStreamingMode(bytes.length);
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestProperty("Authorization", "Bearer " + accessToken);
        conn.setRequestMethod("POST");
        OutputStream out = null;
        try {
            out = conn.getOutputStream();
            out.write(bytes);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpURLConnection refreshAccessToken(ChromePackagedAppVariant chromePackagedAppVariant) throws IOException {
        String body = "client_secret=" + chromePackagedAppVariant.getClientSecret() + "&grant_type=refresh_token&refresh_token=" + chromePackagedAppVariant.getRefreshToken() + "&client_id=" + chromePackagedAppVariant.getClientId();
        byte[] bytes = body.getBytes(UTF_8);
        HttpURLConnection conn = this.getConnection(ACCESS_TOKEN_URL);
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setFixedLengthStreamingMode(bytes.length);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        OutputStream out = null;
        try {
            out = conn.getOutputStream();
            out.write(bytes);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String fetchAccessToken(ChromePackagedAppVariant chromePackagedAppVariant) {
        HttpURLConnection accessTokenConn = null;
        JSONParser jsonParser = new JSONParser();
        ChromePackagedAppTokenCache accessTokenObject = null;
        String accessToken = null;
        long expireTime = 0L;
        try {
            accessTokenObject = this.accessTokenMap.get(chromePackagedAppVariant.getClientId());
            if (accessTokenObject != null) {
                accessToken = accessTokenObject.getAccessToken();
                expireTime = accessTokenObject.getExpiresIn();
            }
            if (accessToken == null || expireTime < new Date().getTime()) {
                accessTokenConn = this.refreshAccessToken(chromePackagedAppVariant);
                String stringResponse = GCMForChromePushNotificationSender.getString(accessTokenConn.getInputStream());
                accessToken = ((JSONObject)jsonParser.parse(stringResponse)).get((Object)"access_token").toString();
                String expiresIn = ((JSONObject)jsonParser.parse(stringResponse)).get((Object)"expires_in").toString();
                long ex = Long.parseLong(expiresIn);
                expireTime = new Date().getTime() + ex * 1000L;
                if (accessTokenObject == null) {
                    accessTokenObject = new ChromePackagedAppTokenCache();
                }
                accessTokenObject.setAccessToken(accessToken);
                accessTokenObject.setExpiresIn(expireTime);
                this.accessTokenMap.put(chromePackagedAppVariant.getClientId(), accessTokenObject);
            }
        }
        catch (IOException e) {
            this.logger.severe("Error during Post execution to GCM for Chrome Network For access token refresh", (Throwable)e);
        }
        catch (ParseException e) {
            this.logger.severe("Error during Parse of Response ", (Throwable)e);
        }
        finally {
            if (accessTokenConn != null) {
                accessTokenConn.disconnect();
            }
        }
        return accessToken;
    }

    protected HttpURLConnection getConnection(String url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        return conn;
    }

    protected static String getString(InputStream stream) throws IOException {
        String newLine;
        BufferedReader reader = new BufferedReader(new InputStreamReader(GCMForChromePushNotificationSender.nonNull(stream)));
        StringBuilder content = new StringBuilder();
        do {
            if ((newLine = reader.readLine()) == null) continue;
            content.append(newLine).append('\n');
        } while (newLine != null);
        if (content.length() > 0) {
            content.setLength(content.length() - 1);
        }
        return content.toString();
    }

    static <T> T nonNull(T argument) {
        if (argument == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        return argument;
    }
}

