/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.sender;

import com.notnoop.apns.APNS;
import com.notnoop.apns.ApnsDelegate;
import com.notnoop.apns.ApnsDelegateAdapter;
import com.notnoop.apns.ApnsNotification;
import com.notnoop.apns.ApnsService;
import com.notnoop.apns.ApnsServiceBuilder;
import com.notnoop.apns.DeliveryError;
import com.notnoop.apns.PayloadBuilder;
import com.notnoop.apns.internal.Utilities;
import com.notnoop.exceptions.ApnsDeliveryErrorException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.api.iOSVariant;
import org.jboss.aerogear.unifiedpush.message.UnifiedPushMessage;
import org.jboss.aerogear.unifiedpush.message.sender.NotificationSenderCallback;
import org.jboss.aerogear.unifiedpush.message.sender.PushNotificationSender;
import org.jboss.aerogear.unifiedpush.message.sender.SenderType;
import org.jboss.aerogear.unifiedpush.message.util.ConfigurationUtils;
import org.jboss.aerogear.unifiedpush.service.ClientInstallationService;
import org.jboss.aerogear.unifiedpush.utils.AeroGearLogger;

@SenderType(value=iOSVariant.class)
public class APNsPushNotificationSender
implements PushNotificationSender {
    private static final String CUSTOM_AEROGEAR_APNS_PUSH_HOST = "custom.aerogear.apns.push.host";
    private static final String CUSTOM_AEROGEAR_APNS_PUSH_PORT = "custom.aerogear.apns.push.port";
    private static final String CUSTOM_AEROGEAR_APNS_FEEDBACK_HOST = "custom.aerogear.apns.feedback.host";
    private static final String CUSTOM_AEROGEAR_APNS_FEEDBACK_PORT = "custom.aerogear.apns.feedback.port";
    private static final String customAerogearApnsPushHost = ConfigurationUtils.tryGetProperty("custom.aerogear.apns.push.host");
    private static final Integer customAerogearApnsPushPort = ConfigurationUtils.tryGetIntegerProperty("custom.aerogear.apns.push.port");
    private static final String customAerogearApnsFeedbackHost = ConfigurationUtils.tryGetProperty("custom.aerogear.apns.feedback.host");
    private static final Integer customAerogearApnsFeedbackPort = ConfigurationUtils.tryGetIntegerProperty("custom.aerogear.apns.feedback.port");
    private final AeroGearLogger logger = AeroGearLogger.getInstance(APNsPushNotificationSender.class);
    @Inject
    private ClientInstallationService clientInstallationService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendPushMessage(Variant variant, Collection<String> tokens, UnifiedPushMessage pushMessage, NotificationSenderCallback callback) {
        if (tokens.isEmpty()) {
            return;
        }
        iOSVariant iOSVariant2 = (iOSVariant)variant;
        PayloadBuilder builder = APNS.newPayload().alertBody(pushMessage.getAlert()).badge(pushMessage.getBadge()).sound(pushMessage.getSound()).category(pushMessage.getActionCategory());
        if (pushMessage.isContentAvailable()) {
            builder = builder.instantDeliveryOrSilentNotification();
        }
        if ((builder = builder.customFields(pushMessage.getData())).isTooLong()) {
            callback.onError("Nothing sent to APNs since the payload is too large");
            return;
        }
        String apnsMessage = builder.build();
        ApnsService service = this.buildApnsService(iOSVariant2, callback);
        if (service != null) {
            try {
                this.logger.fine("Sending transformed APNs payload: " + apnsMessage);
                service.start();
                Date expireDate = this.createFutureDateBasedOnTTL(pushMessage.getTimeToLive());
                service.push(tokens, apnsMessage, expireDate);
                this.logger.info("Message to APNs has been submitted");
                Set<String> inactiveTokens = service.getInactiveDevices().keySet();
                Set<String> transformedTokens = this.lowerCaseAllTokens(inactiveTokens);
                if (!transformedTokens.isEmpty()) {
                    this.logger.info("Deleting '" + inactiveTokens.size() + "' invalid iOS installations");
                    this.clientInstallationService.removeInstallationsForVariantByDeviceTokens(iOSVariant2.getVariantID(), transformedTokens);
                }
                callback.onSuccess();
            }
            catch (Exception e) {
                callback.onError("Error sending payload to APNs server: " + e.getMessage());
            }
            finally {
                service.stop();
            }
        } else {
            callback.onError("No certificate was found. Could not send messages to APNs");
        }
    }

    private Date createFutureDateBasedOnTTL(int ttl) {
        if (ttl == -1) {
            return new Date(System.currentTimeMillis() + 2147483647000L);
        }
        return new Date(System.currentTimeMillis() + (long)ttl);
    }

    private Set<String> lowerCaseAllTokens(Set<String> inactiveTokens) {
        HashSet<String> lowerCaseTokens = new HashSet<String>();
        for (String token : inactiveTokens) {
            lowerCaseTokens.add(token.toLowerCase());
        }
        return lowerCaseTokens;
    }

    private ApnsService buildApnsService(final iOSVariant iOSVariant2, NotificationSenderCallback notificationSenderCallback) {
        if (iOSVariant2.getCertificate() != null && iOSVariant2.getPassphrase() != null) {
            ApnsServiceBuilder builder = APNS.newService();
            builder.withDelegate((ApnsDelegate)new ApnsDelegateAdapter(){

                public void messageSent(ApnsNotification message, boolean resent) {
                    APNsPushNotificationSender.this.logger.finest("Sending APNs message to: " + message.getDeviceToken());
                }

                public void messageSendFailed(ApnsNotification message, Throwable e) {
                    if (e.getClass().isAssignableFrom(ApnsDeliveryErrorException.class)) {
                        ApnsDeliveryErrorException deliveryError = (ApnsDeliveryErrorException)e;
                        if (DeliveryError.INVALID_TOKEN.equals((Object)deliveryError.getDeliveryError())) {
                            String invalidToken = Utilities.encodeHex((byte[])message.getDeviceToken()).toLowerCase();
                            APNsPushNotificationSender.this.logger.info("Removing invalid token: " + invalidToken);
                            APNsPushNotificationSender.this.clientInstallationService.removeInstallationForVariantByDeviceToken(iOSVariant2.getVariantID(), invalidToken);
                        } else {
                            APNsPushNotificationSender.this.logger.severe("Error sending payload to APNs server", e);
                        }
                    }
                }
            });
            try {
                ByteArrayInputStream stream = new ByteArrayInputStream(iOSVariant2.getCertificate());
                builder.withCert((InputStream)stream, iOSVariant2.getPassphrase());
                stream.close();
            }
            catch (Exception e) {
                this.logger.severe("Error reading certificate", (Throwable)e);
                return null;
            }
            this.configureDestinations(iOSVariant2, builder);
            return builder.build();
        }
        return null;
    }

    private void configureDestinations(iOSVariant iOSVariant2, ApnsServiceBuilder builder) {
        int port;
        if (iOSVariant2.isProduction()) {
            builder.withProductionDestination();
        } else {
            builder.withSandboxDestination();
        }
        if (customAerogearApnsPushHost != null) {
            port = 2195;
            if (customAerogearApnsPushPort != null) {
                port = customAerogearApnsPushPort;
            }
            builder.withGatewayDestination(customAerogearApnsPushHost, port);
        }
        if (customAerogearApnsFeedbackHost != null) {
            port = 2196;
            if (customAerogearApnsFeedbackPort != null) {
                port = customAerogearApnsFeedbackPort;
            }
            builder.withFeedbackDestination(customAerogearApnsFeedbackHost, port);
        }
    }
}

