/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.sender;

import com.google.android.gcm.server.Message;
import com.google.android.gcm.server.MulticastResult;
import com.google.android.gcm.server.Result;
import com.google.android.gcm.server.Sender;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.jboss.aerogear.unifiedpush.api.AndroidVariant;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.message.UnifiedPushMessage;
import org.jboss.aerogear.unifiedpush.message.sender.NotificationSenderCallback;
import org.jboss.aerogear.unifiedpush.message.sender.PushNotificationSender;
import org.jboss.aerogear.unifiedpush.message.sender.SenderType;
import org.jboss.aerogear.unifiedpush.service.ClientInstallationService;
import org.jboss.aerogear.unifiedpush.utils.AeroGearLogger;

@SenderType(value=AndroidVariant.class)
public class GCMPushNotificationSender
implements PushNotificationSender {
    private static final int GCM_PAGE = 1000;
    private static final Set<String> GCM_ERROR_CODES = new HashSet<String>(Arrays.asList("InvalidRegistration", "NotRegistered"));
    @Inject
    private ClientInstallationService clientInstallationService;
    private final AeroGearLogger logger = AeroGearLogger.getInstance(GCMPushNotificationSender.class);

    @Override
    public void sendPushMessage(Variant variant, Collection<String> tokens, UnifiedPushMessage pushMessage, NotificationSenderCallback callback) {
        if (tokens.isEmpty()) {
            return;
        }
        ArrayList<String> registrationIDs = new ArrayList<String>(tokens);
        AndroidVariant androidVariant = (AndroidVariant)variant;
        Message.Builder gcmBuilder = new Message.Builder();
        gcmBuilder.addData("alert", pushMessage.getAlert());
        gcmBuilder.addData("sound", pushMessage.getSound());
        gcmBuilder.addData("badge", "" + pushMessage.getBadge());
        int ttl = pushMessage.getTimeToLive();
        if (ttl != -1) {
            gcmBuilder.timeToLive(ttl);
        }
        Set<String> keys = pushMessage.getData().keySet();
        for (String key : keys) {
            gcmBuilder.addData(key, "" + pushMessage.getData().get(key));
        }
        Message gcmMessage = gcmBuilder.build();
        try {
            this.logger.fine("Sending transformed GCM payload: " + gcmMessage);
            Sender sender = new Sender(androidVariant.getGoogleKey());
            while (!registrationIDs.isEmpty()) {
                int toIndex = 1000;
                if (registrationIDs.size() < 1000) {
                    toIndex = registrationIDs.size();
                }
                List<String> sublist = registrationIDs.subList(0, toIndex);
                this.processGCM(androidVariant, sublist, gcmMessage, sender);
                registrationIDs.removeAll(sublist);
            }
            this.logger.info("Message to GCM has been submitted");
            callback.onSuccess();
        }
        catch (Exception e) {
            this.logger.severe("Error sending payload to GCM server", (Throwable)e);
            callback.onError("Error sending payload to GCM server");
        }
    }

    private void processGCM(AndroidVariant androidVariant, List<String> registrationIDs, Message gcmMessage, Sender sender) throws IOException {
        this.logger.info("Sending payload for [" + registrationIDs.size() + "] devices to GCM");
        MulticastResult multicastResult = sender.send(gcmMessage, registrationIDs, 0);
        this.cleanupInvalidRegistrationIDsForVariant(androidVariant.getVariantID(), multicastResult, registrationIDs);
    }

    private void cleanupInvalidRegistrationIDsForVariant(String variantID, MulticastResult multicastResult, List<String> registrationIDs) {
        List results = multicastResult.getResults();
        HashSet<String> inactiveTokens = new HashSet<String>();
        for (int i = 0; i < results.size(); ++i) {
            Result result = (Result)results.get(i);
            String errorCodeName = result.getErrorCodeName();
            if (!GCM_ERROR_CODES.contains(errorCodeName)) continue;
            inactiveTokens.add(registrationIDs.get(i));
        }
        this.logger.fine("Deleting '" + inactiveTokens.size() + "' invalid Android installations");
        this.clientInstallationService.removeInstallationsForVariantByDeviceTokens(variantID, inactiveTokens);
    }
}

