/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.jpa;

import java.sql.DatabaseMetaData;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.exception.JDBCConnectionException;
import org.hibernate.service.jdbc.dialect.spi.DialectResolver;
import org.jboss.aerogear.unifiedpush.jpa.Mysql5BitBooleanDialect;
import org.jboss.aerogear.unifiedpush.utils.AeroGearLogger;

public class MysqlDialectResolver
implements DialectResolver {
    private final AeroGearLogger logger = AeroGearLogger.getInstance(MysqlDialectResolver.class);

    public Dialect resolveDialect(DatabaseMetaData databaseMetaData) throws JDBCConnectionException {
        try {
            if ("MySQL".equals(databaseMetaData.getDatabaseProductName())) {
                return databaseMetaData.getDatabaseMajorVersion() >= 5 ? new Mysql5BitBooleanDialect() : new MySQLDialect();
            }
        }
        catch (Exception e) {
            this.logger.severe("Could not get database name/version", (Throwable)e);
        }
        return null;
    }
}

