/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.service.dashboard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jboss.aerogear.unifiedpush.api.PushApplication;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.dao.InstallationDao;
import org.jboss.aerogear.unifiedpush.dao.PushApplicationDao;
import org.jboss.aerogear.unifiedpush.dao.PushMessageInformationDao;
import org.jboss.aerogear.unifiedpush.service.dashboard.ApplicationVariant;
import org.jboss.aerogear.unifiedpush.service.dashboard.DashboardData;

public class DashboardService {
    @Inject
    private PushApplicationDao pushApplicationDao;
    @Inject
    private InstallationDao installationDao;
    @Inject
    private PushMessageInformationDao pushMessageInformationDao;

    public DashboardData loadDashboardData(String principalName) {
        long totalApps = this.totalApplicationNumber(principalName);
        long totalDevices = this.totalDeviceNumber(principalName);
        long totalMessages = this.totalMessages(principalName);
        DashboardData data = new DashboardData();
        data.setApplications(totalApps);
        data.setDevices(totalDevices);
        data.setMessages(totalMessages);
        return data;
    }

    public List<ApplicationVariant> getVariantsWithWarnings(String principalName) {
        List warningIDs = this.pushMessageInformationDao.findVariantIDsWithWarnings(principalName);
        if (warningIDs.isEmpty()) {
            return Collections.emptyList();
        }
        return this.wrapApplicationVariant(this.pushApplicationDao.findByVariantIds(warningIDs));
    }

    public List<ApplicationVariant> getTopThreeBusyVariants(String principalName) {
        Map topVariantIDs = this.pushMessageInformationDao.findTopThreeBusyVariantIDs(principalName);
        if (topVariantIDs.isEmpty()) {
            return Collections.emptyList();
        }
        List applications = this.pushApplicationDao.findByVariantIds(new ArrayList(topVariantIDs.keySet()));
        List<ApplicationVariant> applicationVariants = this.wrapApplicationVariant(applications);
        for (ApplicationVariant applicationVariant : applicationVariants) {
            String id = applicationVariant.getVariant().getVariantID();
            applicationVariant.setReceivers((Long)topVariantIDs.get(id));
        }
        Collections.sort(applicationVariants, new Comparator<ApplicationVariant>(){

            @Override
            public int compare(ApplicationVariant o1, ApplicationVariant o2) {
                return o2.getReceivers().compareTo(o1.getReceivers());
            }
        });
        return applicationVariants;
    }

    private List<ApplicationVariant> wrapApplicationVariant(List<PushApplication> applications) {
        ArrayList<ApplicationVariant> applicationVariants = new ArrayList<ApplicationVariant>(applications.size());
        for (PushApplication application : applications) {
            for (Variant variant : application.getVariants()) {
                ApplicationVariant applicationVariant = new ApplicationVariant(application, variant);
                applicationVariants.add(applicationVariant);
            }
        }
        return applicationVariants;
    }

    private long totalMessages(String principalName) {
        return this.pushMessageInformationDao.getNumberOfPushMessagesForApplications(principalName);
    }

    private long totalDeviceNumber(String principalName) {
        return this.installationDao.getNumberOfDevicesForVariantIDs(principalName);
    }

    private long totalApplicationNumber(String principalName) {
        return this.pushApplicationDao.getNumberOfPushApplicationsForDeveloper(principalName);
    }
}

