/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.service.impl;

import java.util.List;
import java.util.Set;
import javax.ejb.Asynchronous;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.jboss.aerogear.unifiedpush.api.Installation;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.dao.InstallationDao;
import org.jboss.aerogear.unifiedpush.dao.PageResult;
import org.jboss.aerogear.unifiedpush.service.ClientInstallationService;

@Stateless
public class ClientInstallationServiceImpl
implements ClientInstallationService {
    @Inject
    private InstallationDao dao;

    @Override
    public void addInstallation(Variant variant, Installation installation) {
        installation.setVariant(variant);
        this.dao.create((Object)installation);
    }

    @Override
    public void removeInstallations(List<Installation> installations) {
        for (Installation installation : installations) {
            this.removeInstallation(installation);
        }
    }

    @Override
    public PageResult<Installation> findInstallationsByVariant(String variantId, String developer, Integer page, Integer pageSize) {
        return this.dao.findInstallationsByVariant(variantId, developer, page, pageSize);
    }

    @Override
    public void updateInstallation(Installation installation) {
        this.dao.update((Object)installation);
    }

    @Override
    public void updateInstallation(Installation installationToUpdate, Installation postedInstallation) {
        installationToUpdate.setCategories(postedInstallation.getCategories());
        installationToUpdate.setDeviceToken(postedInstallation.getDeviceToken());
        installationToUpdate.setAlias(postedInstallation.getAlias());
        installationToUpdate.setDeviceType(postedInstallation.getDeviceType());
        installationToUpdate.setOperatingSystem(postedInstallation.getOperatingSystem());
        installationToUpdate.setOsVersion(postedInstallation.getOsVersion());
        installationToUpdate.setEnabled(postedInstallation.isEnabled());
        installationToUpdate.setPlatform(postedInstallation.getPlatform());
        this.updateInstallation(installationToUpdate);
    }

    @Override
    public Installation findById(String primaryKey) {
        return (Installation)this.dao.find((Object)primaryKey);
    }

    @Override
    public void removeInstallation(Installation installation) {
        this.dao.delete((Object)installation);
    }

    @Override
    @Asynchronous
    public void removeInstallationsForVariantByDeviceTokens(String variantID, Set<String> deviceTokens) {
        List inactiveInstallations = this.dao.findInstallationsForVariantByDeviceTokens(variantID, deviceTokens);
        this.removeInstallations(inactiveInstallations);
    }

    @Override
    public Installation findInstallationForVariantByDeviceToken(String variantID, String deviceToken) {
        return this.dao.findInstallationForVariantByDeviceToken(variantID, deviceToken);
    }

    @Override
    public List<String> findAllDeviceTokenForVariantIDByCriteria(String variantID, List<String> categories, List<String> aliases, List<String> deviceTypes) {
        return this.dao.findAllDeviceTokenForVariantIDByCriteria(variantID, categories, aliases, deviceTypes);
    }
}

