/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.service.dashboard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.jboss.aerogear.unifiedpush.api.PushApplication;
import org.jboss.aerogear.unifiedpush.api.PushMessageInformation;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.dao.InstallationDao;
import org.jboss.aerogear.unifiedpush.dao.PushApplicationDao;
import org.jboss.aerogear.unifiedpush.dao.PushMessageInformationDao;
import org.jboss.aerogear.unifiedpush.service.dashboard.Application;
import org.jboss.aerogear.unifiedpush.service.dashboard.ApplicationVariant;
import org.jboss.aerogear.unifiedpush.service.dashboard.DashboardData;

public class DashboardService {
    @Inject
    private PushApplicationDao pushApplicationDao;
    @Inject
    private InstallationDao installationDao;
    @Inject
    private PushMessageInformationDao pushMessageInformationDao;

    public DashboardData loadDashboardData(String principalName) {
        long totalApps = this.totalApplicationNumber(principalName);
        long totalDevices = this.totalDeviceNumber(principalName);
        long totalMessages = this.totalMessages(principalName);
        DashboardData data = new DashboardData();
        data.setApplications(totalApps);
        data.setDevices(totalDevices);
        data.setMessages(totalMessages);
        return data;
    }

    public List<ApplicationVariant> getVariantsWithWarnings(String principalName) {
        List warningIDs = this.pushMessageInformationDao.findVariantIDsWithWarnings(principalName);
        if (warningIDs.isEmpty()) {
            return Collections.emptyList();
        }
        return this.wrapApplicationVariant(this.pushApplicationDao.findByVariantIds(warningIDs));
    }

    public List<Application> getTopThreeLastActivity(String principalName) {
        return this.wrapApplication(this.pushMessageInformationDao.findLastThreeActivity(principalName));
    }

    private List<ApplicationVariant> wrapApplicationVariant(List<PushApplication> applications) {
        ArrayList<ApplicationVariant> applicationVariants = new ArrayList<ApplicationVariant>(applications.size());
        for (PushApplication application : applications) {
            for (Variant variant : application.getVariants()) {
                ApplicationVariant applicationVariant = new ApplicationVariant(application, variant);
                applicationVariants.add(applicationVariant);
            }
        }
        return applicationVariants;
    }

    private List<Application> wrapApplication(List<PushMessageInformation> pushMessageInformations) {
        ArrayList<Application> applications = new ArrayList<Application>(pushMessageInformations.size());
        for (PushMessageInformation pushMessageInformation : pushMessageInformations) {
            String applicationName = this.pushApplicationDao.findByPushApplicationID(pushMessageInformation.getPushApplicationId()).getName();
            Application application = new Application(applicationName, pushMessageInformation.getPushApplicationId(), pushMessageInformation.getTotalReceivers(), pushMessageInformation.getSubmitDate());
            applications.add(application);
        }
        return applications;
    }

    private long totalMessages(String principalName) {
        return this.pushMessageInformationDao.getNumberOfPushMessagesForApplications(principalName);
    }

    private long totalDeviceNumber(String principalName) {
        return this.installationDao.getNumberOfDevicesForVariantIDs(principalName);
    }

    private long totalApplicationNumber(String principalName) {
        return this.pushApplicationDao.getNumberOfPushApplicationsForDeveloper(principalName);
    }
}

