/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.service.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Asynchronous;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.jboss.aerogear.unifiedpush.api.Installation;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.dao.InstallationDao;
import org.jboss.aerogear.unifiedpush.dao.PageResult;
import org.jboss.aerogear.unifiedpush.service.ClientInstallationService;

@Stateless
public class ClientInstallationServiceImpl
implements ClientInstallationService {
    private final Logger logger = Logger.getLogger(ClientInstallationServiceImpl.class.getName());
    @Inject
    private InstallationDao dao;

    @Override
    @Asynchronous
    public void addInstallation(Variant variant, Installation entity) {
        Installation installation = this.findInstallationForVariantByDeviceToken(variant.getVariantID(), entity.getDeviceToken());
        entity.setPlatform(variant.getType().getTypeName());
        if (installation == null) {
            this.logger.log(Level.FINEST, "Performing new device/client registration");
            entity.setVariant(variant);
            this.dao.create((Object)entity);
        } else if (installation.isEnabled()) {
            this.logger.log(Level.FINEST, "Updating received metadata for an 'enabled' installation");
            this.updateInstallation(installation, entity);
        }
    }

    @Override
    @Asynchronous
    public void addInstallations(Variant variant, List<Installation> installations) {
        if (installations == null || installations.isEmpty()) {
            return;
        }
        HashSet<String> existingTokens = new HashSet<String>(this.findAllDeviceTokenForVariantIDByCriteria(variant.getVariantID(), null, null, null));
        this.dao.flushAndClear();
        for (int i = 0; i < installations.size(); ++i) {
            Installation current = installations.get(i);
            if (!existingTokens.contains(current.getDeviceToken()) && this.hasTokenValue(current)) {
                this.logger.log(Level.FINEST, "Importing device with token: " + current.getDeviceToken());
                current.setVariant(variant);
                this.dao.create((Object)current);
                existingTokens.add(current.getDeviceToken());
                if (i % 10000 != 0) continue;
                this.logger.log(Level.FINEST, "releasing some resources during import");
                this.dao.flushAndClear();
                continue;
            }
            this.logger.log(Level.FINEST, "Device with token '" + current.getDeviceToken() + "' already exists. Ignoring it ");
        }
        this.dao.flushAndClear();
    }

    @Override
    public void removeInstallations(List<Installation> installations) {
        for (Installation installation : installations) {
            this.removeInstallation(installation);
        }
    }

    @Override
    public PageResult<Installation> findInstallationsByVariant(String variantId, String developer, Integer page, Integer pageSize) {
        return this.dao.findInstallationsByVariant(variantId, developer, page, pageSize);
    }

    @Override
    public void updateInstallation(Installation installation) {
        this.dao.update((Object)installation);
    }

    @Override
    public void updateInstallation(Installation installationToUpdate, Installation postedInstallation) {
        installationToUpdate.setCategories(postedInstallation.getCategories());
        installationToUpdate.setDeviceToken(postedInstallation.getDeviceToken());
        installationToUpdate.setAlias(postedInstallation.getAlias());
        installationToUpdate.setDeviceType(postedInstallation.getDeviceType());
        installationToUpdate.setOperatingSystem(postedInstallation.getOperatingSystem());
        installationToUpdate.setOsVersion(postedInstallation.getOsVersion());
        installationToUpdate.setEnabled(postedInstallation.isEnabled());
        installationToUpdate.setPlatform(postedInstallation.getPlatform());
        this.updateInstallation(installationToUpdate);
    }

    @Override
    public Installation findById(String primaryKey) {
        return (Installation)this.dao.find((Object)primaryKey);
    }

    @Override
    public void removeInstallation(Installation installation) {
        this.dao.delete((Object)installation);
    }

    @Override
    @Asynchronous
    public void removeInstallationsForVariantByDeviceTokens(String variantID, Set<String> deviceTokens) {
        List inactiveInstallations = this.dao.findInstallationsForVariantByDeviceTokens(variantID, deviceTokens);
        this.removeInstallations(inactiveInstallations);
    }

    @Override
    public Installation findInstallationForVariantByDeviceToken(String variantID, String deviceToken) {
        return this.dao.findInstallationForVariantByDeviceToken(variantID, deviceToken);
    }

    @Override
    public List<String> findAllDeviceTokenForVariantIDByCriteria(String variantID, List<String> categories, List<String> aliases, List<String> deviceTypes) {
        return this.dao.findAllDeviceTokenForVariantIDByCriteria(variantID, categories, aliases, deviceTypes);
    }

    private boolean hasTokenValue(Installation installation) {
        return installation.getDeviceToken() != null && !installation.getDeviceToken().isEmpty();
    }
}

