/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.service.metrics;

import java.util.Date;
import javax.inject.Inject;
import org.jboss.aerogear.unifiedpush.api.PushMessageInformation;
import org.jboss.aerogear.unifiedpush.dao.PageResult;
import org.jboss.aerogear.unifiedpush.dao.PushMessageInformationDao;
import org.jboss.aerogear.unifiedpush.utils.DateUtils;

public class PushMessageMetricsService {
    private static final int DAYS_OF_MAX_OLDEST_INFO_MSG = 30;
    @Inject
    private PushMessageInformationDao pushMessageInformationDao;

    public PushMessageInformation storeNewRequestFrom(String pushAppId, String json, String ipAddress, String clientIdentifier) {
        PushMessageInformation information = new PushMessageInformation();
        information.setRawJsonMessage(json);
        information.setIpAddress(ipAddress);
        information.setPushApplicationId(pushAppId);
        information.setClientIdentifier(clientIdentifier);
        this.pushMessageInformationDao.create((Object)information);
        return information;
    }

    public void updatePushMessageInformation(PushMessageInformation pushMessageInformation) {
        this.pushMessageInformationDao.update((Object)pushMessageInformation);
    }

    public PageResult<PushMessageInformation> findAllForPushApplication(String pushApplicationID, boolean sorting, Integer page, Integer pageSize) {
        return this.pushMessageInformationDao.findAllForPushApplication(pushApplicationID, sorting, page, pageSize);
    }

    public PageResult<PushMessageInformation> findAllForVariant(String variantID, boolean sorting, Integer page, Integer pageSize) {
        return this.pushMessageInformationDao.findAllForVariant(variantID, sorting, page, pageSize);
    }

    public void deleteOutdatedPushInformationData() {
        Date historyDate = DateUtils.calculatePastDate((int)30);
        this.pushMessageInformationDao.deletePushInformationOlderThan(historyDate);
    }
}

