/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.ejb.Asynchronous;
import javax.ejb.Stateless;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.aerogear.unifiedpush.api.Category;
import org.jboss.aerogear.unifiedpush.api.Installation;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.api.VariantType;
import org.jboss.aerogear.unifiedpush.dao.CategoryDao;
import org.jboss.aerogear.unifiedpush.dao.InstallationDao;
import org.jboss.aerogear.unifiedpush.dao.ResultsStream;
import org.jboss.aerogear.unifiedpush.service.ClientInstallationService;
import org.jboss.aerogear.unifiedpush.service.annotations.LoggedIn;
import org.jboss.aerogear.unifiedpush.utils.AeroGearLogger;

@Stateless
public class ClientInstallationServiceImpl
implements ClientInstallationService {
    private final AeroGearLogger logger = AeroGearLogger.getInstance(ClientInstallationServiceImpl.class);
    @Inject
    private InstallationDao installationDao;
    @Inject
    private CategoryDao categoryDao;
    @Inject
    @LoggedIn
    private Instance<String> developer;

    @Override
    @Asynchronous
    public void addInstallation(Variant variant, Installation entity) {
        Installation installation = this.findInstallationForVariantByDeviceToken(variant.getVariantID(), entity.getDeviceToken());
        entity.setPlatform(variant.getType().getTypeName());
        if (installation == null) {
            this.logger.finest("Performing new device/client registration");
            this.storeInstallationAndSetReferences(variant, entity);
        } else if (installation.isEnabled()) {
            this.logger.finest("Updating received metadata for an 'enabled' installation");
            this.updateInstallation(installation, entity);
        }
    }

    @Override
    @Asynchronous
    public void addInstallations(Variant variant, List<Installation> installations) {
        if (installations == null || installations.isEmpty()) {
            return;
        }
        Set existingTokens = this.installationDao.findAllDeviceTokenForVariantID(variant.getVariantID());
        this.installationDao.flushAndClear();
        for (int i = 0; i < installations.size(); ++i) {
            Installation current = installations.get(i);
            if (!existingTokens.contains(current.getDeviceToken()) && this.hasTokenValue(current)) {
                this.logger.finest("Importing device with token: " + current.getDeviceToken());
                this.storeInstallationAndSetReferences(variant, current);
                existingTokens.add(current.getDeviceToken());
                if (i % 10000 != 0) continue;
                this.logger.finest("releasing some resources during import");
                this.installationDao.flushAndClear();
                continue;
            }
            this.logger.finest("Device with token '" + current.getDeviceToken() + "' already exists. Ignoring it ");
        }
        this.installationDao.flushAndClear();
    }

    @Override
    public void removeInstallations(List<Installation> installations) {
        for (Installation installation : installations) {
            this.removeInstallation(installation);
        }
    }

    @Override
    public void updateInstallation(Installation installation) {
        this.installationDao.update((Object)installation);
    }

    @Override
    public void updateInstallation(Installation installationToUpdate, Installation postedInstallation) {
        this.mergeCategories(installationToUpdate, postedInstallation.getCategories());
        installationToUpdate.setDeviceToken(postedInstallation.getDeviceToken());
        installationToUpdate.setAlias(postedInstallation.getAlias());
        installationToUpdate.setDeviceType(postedInstallation.getDeviceType());
        installationToUpdate.setOperatingSystem(postedInstallation.getOperatingSystem());
        installationToUpdate.setOsVersion(postedInstallation.getOsVersion());
        installationToUpdate.setEnabled(postedInstallation.isEnabled());
        installationToUpdate.setPlatform(postedInstallation.getPlatform());
        this.updateInstallation(installationToUpdate);
    }

    @Override
    public Installation findById(String primaryKey) {
        return (Installation)this.installationDao.find((Object)primaryKey);
    }

    @Override
    public void removeInstallation(Installation installation) {
        this.installationDao.delete((Object)installation);
    }

    @Override
    @Asynchronous
    public void removeInstallationsForVariantByDeviceTokens(String variantID, Set<String> deviceTokens) {
        List inactiveInstallations = this.installationDao.findInstallationsForVariantByDeviceTokens(variantID, deviceTokens);
        this.removeInstallations(inactiveInstallations);
    }

    @Override
    @Asynchronous
    public void removeInstallationForVariantByDeviceToken(String variantID, String deviceToken) {
        this.removeInstallation(this.findInstallationForVariantByDeviceToken(variantID, deviceToken));
    }

    @Override
    public Installation findInstallationForVariantByDeviceToken(String variantID, String deviceToken) {
        return this.installationDao.findInstallationForVariantByDeviceToken(variantID, deviceToken);
    }

    @Override
    public ResultsStream.QueryBuilder<String> findAllDeviceTokenForVariantIDByCriteria(String variantID, List<String> categories, List<String> aliases, List<String> deviceTypes, int maxResults, String lastTokenFromPreviousBatch) {
        return this.installationDao.findAllDeviceTokenForVariantIDByCriteria(variantID, categories, aliases, deviceTypes, maxResults, lastTokenFromPreviousBatch);
    }

    private boolean hasTokenValue(Installation installation) {
        return installation.getDeviceToken() != null && !installation.getDeviceToken().isEmpty();
    }

    private void mergeCategories(Installation entity, Set<Category> categoriesToMerge) {
        if (entity.getCategories() != null) {
            List<String> categoryNames = this.convertToNames(categoriesToMerge);
            List existingCategoriesFromDB = this.categoryDao.findByNames(categoryNames);
            categoriesToMerge.removeAll(existingCategoriesFromDB);
            categoriesToMerge.addAll(existingCategoriesFromDB);
            entity.setCategories(categoriesToMerge);
        }
    }

    private List<String> convertToNames(Set<Category> categories) {
        ArrayList<String> result = new ArrayList<String>();
        for (Category category : categories) {
            result.add(category.getName());
        }
        return result;
    }

    private void storeInstallationAndSetReferences(Variant variant, Installation entity) {
        if (variant.getType().equals((Object)VariantType.IOS)) {
            entity.setDeviceToken(entity.getDeviceToken().toLowerCase());
        }
        entity.setVariant(variant);
        this.mergeCategories(entity, entity.getCategories());
        this.installationDao.create((Object)entity);
    }
}

