/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.service.impl;

import java.io.Serializable;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.jboss.aerogear.unifiedpush.service.PushSearchService;
import org.jboss.aerogear.unifiedpush.service.annotations.LoggedIn;
import org.jboss.aerogear.unifiedpush.service.impl.PushSearchByDeveloperServiceImpl;
import org.jboss.aerogear.unifiedpush.service.impl.PushSearchServiceImpl;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.KeycloakSecurityContext;

@RequestScoped
public class SearchManager
implements Serializable {
    private static final long serialVersionUID = -6665967856424444078L;
    private HttpServletRequest httpServletRequest;
    @Inject
    private PushSearchServiceImpl searchAll;
    @Inject
    private PushSearchByDeveloperServiceImpl searchByDeveloper;

    public void setHttpServletRequest(HttpServletRequest httpServletRequest) {
        this.httpServletRequest = httpServletRequest;
    }

    public PushSearchService getSearchService() {
        boolean isAdmin = this.httpServletRequest.isUserInRole("admin");
        if (isAdmin) {
            return this.searchAll;
        }
        return this.searchByDeveloper;
    }

    @Produces
    @LoggedIn
    public String extractUsername() {
        KeycloakPrincipal p = (KeycloakPrincipal)this.httpServletRequest.getUserPrincipal();
        KeycloakSecurityContext kcSecurityContext = p.getKeycloakSecurityContext();
        return kcSecurityContext.getToken().getPreferredUsername();
    }
}

