/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.service.impl.health;

import java.util.ArrayList;
import java.util.List;
import org.jboss.aerogear.unifiedpush.service.impl.health.HealthDetails;
import org.jboss.aerogear.unifiedpush.service.impl.health.Status;

public class HealthStatus {
    private static final String NO_ERROR = "Everything is ok";
    private static final String ONE_ERROR_MESSAGE = "There is 1 error found";
    private static final String ERROR_MESSAGE = "There are %d errors found";
    private Status status = Status.OK;
    private List<HealthDetails> details = new ArrayList<HealthDetails>();

    public void add(HealthDetails healthDetails) {
        if (this.status.ordinal() < healthDetails.getTestStatus().ordinal()) {
            this.status = healthDetails.getTestStatus();
        }
        this.details.add(healthDetails);
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getSummary() {
        int numberOfErrors = 0;
        for (HealthDetails detail : this.details) {
            if (detail.getTestStatus() == Status.OK) continue;
            ++numberOfErrors;
        }
        return numberOfErrors == 0 ? NO_ERROR : (numberOfErrors == 1 ? ONE_ERROR_MESSAGE : String.format(ERROR_MESSAGE, numberOfErrors));
    }

    public List<HealthDetails> getDetails() {
        return this.details;
    }

    public void setDetails(List<HealthDetails> details) {
        this.details = details;
    }
}

