/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.service.impl.health;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import org.jboss.aerogear.unifiedpush.service.proxy.ProxyConfiguration;

public class Ping {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isReachable(String host, int port) {
        boolean reachable;
        Socket socket = null;
        try {
            if (ProxyConfiguration.hasSocksProxyConfig().booleanValue()) {
                Proxy socksProxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(ProxyConfiguration.socks().getAddress(), ProxyConfiguration.socks().getPort()));
                socket = new Socket(socksProxy);
            } else if (ProxyConfiguration.hasHttpProxyConfig().booleanValue()) {
                Proxy httpProxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(ProxyConfiguration.proxyAddress().getAddress(), ProxyConfiguration.proxyAddress().getPort()));
                socket = new Socket(httpProxy);
            } else {
                socket = new Socket();
            }
            socket.connect(new InetSocketAddress(host, port), 2000);
            reachable = true;
        }
        catch (IOException e) {
            reachable = false;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        return reachable;
    }
}

