/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.service.impl;

import java.io.Serializable;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.jboss.aerogear.unifiedpush.auth.HttpBasicHelper;
import org.jboss.aerogear.unifiedpush.service.PushSearchService;
import org.jboss.aerogear.unifiedpush.service.annotations.LoggedIn;
import org.jboss.aerogear.unifiedpush.service.impl.PushSearchByDeveloperServiceImpl;
import org.jboss.aerogear.unifiedpush.service.impl.PushSearchServiceImpl;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.KeycloakSecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class SearchManager
implements Serializable {
    private static final long serialVersionUID = -6665967856424444078L;
    private static final Logger logger = LoggerFactory.getLogger(SearchManager.class);
    private HttpServletRequest httpServletRequest;
    @Inject
    private PushSearchServiceImpl searchAll;
    @Inject
    private PushSearchByDeveloperServiceImpl searchByDeveloper;

    public void setHttpServletRequest(HttpServletRequest httpServletRequest) {
        this.httpServletRequest = httpServletRequest;
    }

    public PushSearchService getSearchService() {
        boolean isAdmin = this.httpServletRequest.isUserInRole("admin");
        if (isAdmin) {
            return this.searchAll;
        }
        return this.searchByDeveloper;
    }

    @Produces
    @LoggedIn
    public String extractUsername() {
        KeycloakPrincipal principal = (KeycloakPrincipal)this.httpServletRequest.getUserPrincipal();
        if (principal != null) {
            logger.debug("Running with Keycloak context");
            KeycloakSecurityContext kcSecurityContext = principal.getKeycloakSecurityContext();
            return kcSecurityContext.getToken().getPreferredUsername();
        }
        logger.debug("Running outside of Keycloak context");
        String basicUsername = HttpBasicHelper.extractUsernameAndPasswordFromBasicHeader((HttpServletRequest)this.httpServletRequest)[0];
        if (!basicUsername.isEmpty()) {
            logger.debug("running HttpBasic auth");
            return basicUsername;
        }
        logger.debug("Running without any Auth context");
        return "developer";
    }
}

