/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.service.proxy;

import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import javax.annotation.PostConstruct;
import javax.ejb.Singleton;
import javax.ejb.Startup;

@Startup
@Singleton
public class ProxyConfiguration {
    @PostConstruct
    public void setupAuth() {
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                String proxyHost = System.getenv("HTTP_PROXY_HOST");
                String proxyUser = System.getenv("HTTP_PROXY_USER");
                String proxyPass = System.getenv("HTTP_PROXY_PASS");
                String hostAskingForAuth = this.getRequestingHost();
                if (hostAskingForAuth.equals(proxyHost) && !"".equals(proxyUser) && !"".equals(proxyPass)) {
                    return new PasswordAuthentication(proxyUser, proxyPass.toCharArray());
                }
                return super.getPasswordAuthentication();
            }
        });
    }

    public static Boolean hasHttpProxyConfig() {
        String proxyHost = System.getenv("HTTP_PROXY_HOST");
        String proxyPort = System.getenv("HTTP_PROXY_PORT");
        return null != proxyPort && !"".equals(proxyPort) && null != proxyHost && !"".equals(proxyHost);
    }

    public static Boolean hasBasicAuth() {
        String proxyUser = System.getenv("HTTP_PROXY_USER");
        String proxyPass = System.getenv("HTTP_PROXY_PASS");
        return proxyUser != null && !"".equals(proxyUser) && proxyPass != null && !"".equals(proxyPass);
    }

    public static InetSocketAddress proxyAddress() {
        String proxyHost = System.getenv("HTTP_PROXY_HOST");
        String proxyPort = System.getenv("HTTP_PROXY_PORT");
        int port = Integer.parseInt(proxyPort);
        return new InetSocketAddress(proxyHost, port);
    }

    public static Boolean hasSocksProxyConfig() {
        String socksHost = System.getenv("SOCKS_PROXY_HOST");
        String socksPort = System.getenv("SOCKS_PROXY_PORT");
        return null != socksPort && !"".equals(socksPort) && null != socksHost && !"".equals(socksHost);
    }

    public static InetSocketAddress socks() {
        String socksHost = System.getenv("SOCKS_PROXY_HOST");
        String socksPort = System.getenv("SOCKS_PROXY_PORT");
        int port = Integer.parseInt(socksPort);
        return new InetSocketAddress(socksHost, port);
    }

    public static String getProxyUser() {
        return System.getenv("HTTP_PROXY_USER");
    }

    public static String getProxyPass() {
        return System.getenv("HTTP_PROXY_PASS");
    }
}

