/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.service.impl;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ejb.Asynchronous;
import javax.ejb.Stateless;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.aerogear.unifiedpush.api.AndroidVariant;
import org.jboss.aerogear.unifiedpush.api.Category;
import org.jboss.aerogear.unifiedpush.api.Installation;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.api.VariantType;
import org.jboss.aerogear.unifiedpush.dao.CategoryDao;
import org.jboss.aerogear.unifiedpush.dao.InstallationDao;
import org.jboss.aerogear.unifiedpush.dao.ResultsStream;
import org.jboss.aerogear.unifiedpush.service.ClientInstallationService;
import org.jboss.aerogear.unifiedpush.service.annotations.LoggedIn;
import org.jboss.aerogear.unifiedpush.service.util.FCMTopicManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
public class ClientInstallationServiceImpl
implements ClientInstallationService {
    private static final Logger logger = LoggerFactory.getLogger(ClientInstallationServiceImpl.class);
    @Inject
    private InstallationDao installationDao;
    @Inject
    private CategoryDao categoryDao;
    @Inject
    @LoggedIn
    private Instance<String> developer;

    @Override
    @Asynchronous
    public void addInstallation(Variant variant, Installation entity) {
        Installation installation = this.findInstallationForVariantByDeviceToken(variant.getVariantID(), entity.getDeviceToken());
        entity.setPlatform(variant.getType().getTypeName());
        if (installation == null) {
            logger.trace("Performing new device/client registration");
            this.storeInstallationAndSetReferences(variant, entity);
        } else if (installation.isEnabled()) {
            logger.trace("Updating received metadata for an 'enabled' installation");
            installation.setVariant(variant);
            this.updateInstallation(installation, entity);
        }
    }

    @Override
    @Asynchronous
    public void addInstallations(Variant variant, List<Installation> installations) {
        if (installations == null || installations.isEmpty()) {
            return;
        }
        Set existingTokens = this.installationDao.findAllDeviceTokenForVariantID(variant.getVariantID());
        this.installationDao.flushAndClear();
        for (int i = 0; i < installations.size(); ++i) {
            Installation current = installations.get(i);
            if (!existingTokens.contains(current.getDeviceToken()) && ClientInstallationServiceImpl.hasTokenValue(current)) {
                logger.trace("Importing device with token: {}", (Object)current.getDeviceToken());
                this.storeInstallationAndSetReferences(variant, current);
                existingTokens.add(current.getDeviceToken());
                if (i % 10000 != 0) continue;
                logger.trace("releasing some resources during import");
                this.installationDao.flushAndClear();
                continue;
            }
            logger.trace("Device with token '{}' already exists. Ignoring it ", (Object)current.getDeviceToken());
        }
        this.installationDao.flushAndClear();
    }

    @Override
    public void removeInstallations(List<Installation> installations) {
        installations.forEach(this::removeInstallation);
    }

    @Override
    public void updateInstallation(Installation installation) {
        this.installationDao.update((Object)installation);
    }

    @Override
    public void updateInstallation(Installation installationToUpdate, Installation postedInstallation) {
        this.mergeCategories(installationToUpdate, postedInstallation.getCategories());
        installationToUpdate.setDeviceToken(postedInstallation.getDeviceToken());
        installationToUpdate.setAlias(postedInstallation.getAlias());
        installationToUpdate.setDeviceType(postedInstallation.getDeviceType());
        installationToUpdate.setOperatingSystem(postedInstallation.getOperatingSystem());
        installationToUpdate.setOsVersion(postedInstallation.getOsVersion());
        installationToUpdate.setEnabled(postedInstallation.isEnabled());
        installationToUpdate.setPlatform(postedInstallation.getPlatform());
        this.updateInstallation(installationToUpdate);
        if (installationToUpdate.getVariant().getType() == VariantType.ANDROID) {
            this.unsubscribeOldTopics(installationToUpdate);
        }
    }

    @Override
    public Installation findById(String primaryKey) {
        return (Installation)this.installationDao.find((Object)primaryKey);
    }

    @Override
    public void removeInstallation(Installation installation) {
        this.installationDao.delete((Object)installation);
    }

    @Override
    @Asynchronous
    public void removeInstallationsForVariantByDeviceTokens(String variantID, Set<String> deviceTokens) {
        List inactiveInstallations = this.installationDao.findInstallationsForVariantByDeviceTokens(variantID, deviceTokens);
        this.removeInstallations(inactiveInstallations);
    }

    @Override
    @Asynchronous
    public void removeInstallationForVariantByDeviceToken(String variantID, String deviceToken) {
        this.removeInstallation(this.findInstallationForVariantByDeviceToken(variantID, deviceToken));
    }

    @Override
    public Installation findInstallationForVariantByDeviceToken(String variantID, String deviceToken) {
        return this.installationDao.findInstallationForVariantByDeviceToken(variantID, deviceToken);
    }

    @Override
    @Asynchronous
    public void unsubscribeOldTopics(Installation installation) {
        FCMTopicManager topicManager = new FCMTopicManager((AndroidVariant)installation.getVariant());
        Set<String> oldCategories = topicManager.getSubscribedCategories(installation);
        oldCategories.removeAll(ClientInstallationServiceImpl.convertToNames(installation.getCategories()));
        oldCategories.remove(installation.getVariant().getVariantID());
        for (String categoryName : oldCategories) {
            topicManager.unsubscribe(installation, categoryName);
        }
    }

    @Override
    public ResultsStream.QueryBuilder<String> findAllDeviceTokenForVariantIDByCriteria(String variantID, List<String> categories, List<String> aliases, List<String> deviceTypes, int maxResults, String lastTokenFromPreviousBatch) {
        return this.installationDao.findAllDeviceTokenForVariantIDByCriteria(variantID, categories, aliases, deviceTypes, maxResults, lastTokenFromPreviousBatch, false);
    }

    @Override
    public ResultsStream.QueryBuilder<String> findAllOldGoogleCloudMessagingDeviceTokenForVariantIDByCriteria(String variantID, List<String> categories, List<String> aliases, List<String> deviceTypes, int maxResults, String lastTokenFromPreviousBatch) {
        return this.installationDao.findAllDeviceTokenForVariantIDByCriteria(variantID, categories, aliases, deviceTypes, maxResults, lastTokenFromPreviousBatch, true);
    }

    private static boolean hasTokenValue(Installation installation) {
        return installation.getDeviceToken() != null && !installation.getDeviceToken().isEmpty();
    }

    private void mergeCategories(Installation entity, Set<Category> categoriesToMerge) {
        if (entity.getCategories() != null) {
            List<String> categoryNames = ClientInstallationServiceImpl.convertToNames(categoriesToMerge);
            List existingCategoriesFromDB = this.categoryDao.findByNames(categoryNames);
            categoriesToMerge.removeAll(existingCategoriesFromDB);
            categoriesToMerge.addAll(existingCategoriesFromDB);
            entity.setCategories(categoriesToMerge);
        }
    }

    private static List<String> convertToNames(Set<Category> categories) {
        return categories.stream().map(Category::getName).collect(Collectors.toList());
    }

    private void storeInstallationAndSetReferences(Variant variant, Installation entity) {
        if (variant.getType() == VariantType.IOS) {
            entity.setDeviceToken(entity.getDeviceToken().toLowerCase());
        }
        entity.setVariant(variant);
        this.mergeCategories(entity, entity.getCategories());
        this.installationDao.create((Object)entity);
    }
}

