/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.service.impl;

import java.util.concurrent.Future;
import javax.ejb.AsyncResult;
import javax.ejb.Asynchronous;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.jboss.aerogear.unifiedpush.jpa.dao.impl.JPAHealthDao;
import org.jboss.aerogear.unifiedpush.service.HealthDBService;
import org.jboss.aerogear.unifiedpush.service.impl.health.HealthDetails;
import org.jboss.aerogear.unifiedpush.service.impl.health.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
public class HealthServiceImpl
implements HealthDBService {
    private static final Logger logger = LoggerFactory.getLogger(HealthServiceImpl.class);
    @Inject
    private JPAHealthDao healthDao;

    @Override
    @Asynchronous
    public Future<HealthDetails> dbStatus() {
        HealthDetails details = new HealthDetails();
        details.setDescription("Database connection");
        details.start();
        try {
            logger.trace("Call the DB if it is online");
            this.healthDao.dbCheck();
            details.setTestStatus(Status.OK);
            details.setResult("connected");
        }
        catch (Exception e) {
            details.setTestStatus(Status.CRIT);
            details.setResult(e.getMessage());
        }
        details.stop();
        return new AsyncResult((Object)details);
    }
}

