/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.service.impl.health;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import org.jboss.aerogear.unifiedpush.service.proxy.ProxyConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ping {
    private static final Logger logger = LoggerFactory.getLogger(Ping.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isReachable(String host, int port) {
        boolean reachable;
        Socket socket = null;
        try {
            if (ProxyConfiguration.hasSocksProxyConfig().booleanValue()) {
                logger.trace("We are behind a SOCKS proxy");
                Proxy socksProxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(ProxyConfiguration.socks().getAddress(), ProxyConfiguration.socks().getPort()));
                socket = new Socket(socksProxy);
            } else if (ProxyConfiguration.hasHttpProxyConfig().booleanValue()) {
                logger.trace("We are behind a HTTP proxy");
                Proxy httpProxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(ProxyConfiguration.proxyAddress().getAddress(), ProxyConfiguration.proxyAddress().getPort()));
                socket = new Socket(httpProxy);
            } else {
                logger.trace("No proxy in use");
                socket = new Socket();
            }
            socket.connect(new InetSocketAddress(host, port), 2000);
            logger.trace("Was able to get a route to host '{}'", (Object)host);
            reachable = true;
        }
        catch (IOException e) {
            logger.warn("Unable to get a route to host '{}'", (Object)host);
            logger.debug("Details:", (Throwable)e);
            reachable = false;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        return reachable;
    }
}

