/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.service.metrics;

import java.util.Date;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.jboss.aerogear.unifiedpush.api.FlatPushMessageInformation;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.api.VariantErrorStatus;
import org.jboss.aerogear.unifiedpush.dao.FlatPushMessageInformationDao;
import org.jboss.aerogear.unifiedpush.dao.PageResult;
import org.jboss.aerogear.unifiedpush.dto.MessageMetrics;
import org.jboss.aerogear.unifiedpush.system.ConfigurationUtils;
import org.jboss.aerogear.unifiedpush.utils.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
public class PushMessageMetricsService {
    private static final Logger logger = LoggerFactory.getLogger(PushMessageMetricsService.class);
    public static final String AEROGEAR_METRICS_STORAGE_MAX_DAYS = "aerogear.metrics.storage.days";
    @Inject
    private FlatPushMessageInformationDao flatPushMessageInformationDao;

    public FlatPushMessageInformation storeNewRequestFrom(String pushAppId, String json, String ipAddress, String clientIdentifier) {
        FlatPushMessageInformation information = new FlatPushMessageInformation();
        information.setRawJsonMessage(json);
        information.setIpAddress(ipAddress);
        information.setPushApplicationId(pushAppId);
        information.setClientIdentifier(clientIdentifier);
        logger.trace("starting to track a new Push Message request in the database");
        this.flatPushMessageInformationDao.create((Object)information);
        this.flatPushMessageInformationDao.flushAndClear();
        return information;
    }

    public void updatePushMessageInformation(FlatPushMessageInformation pushMessageInformation) {
        this.flatPushMessageInformationDao.update((Object)pushMessageInformation);
    }

    public void appendError(FlatPushMessageInformation pushMessageInformation, Variant variant, String errorMessage) {
        VariantErrorStatus ves = new VariantErrorStatus(pushMessageInformation, variant, errorMessage);
        pushMessageInformation.getErrors().add(ves);
        try {
            this.flatPushMessageInformationDao.update((Object)pushMessageInformation);
        }
        catch (Exception e) {
            logger.info("Failed to save pushMessageInformation: {}", (Object)e.getMessage());
            logger.debug("Details:", (Throwable)e);
        }
    }

    public PageResult<FlatPushMessageInformation, MessageMetrics> findAllFlatsForPushApplication(String pushApplicationID, String search, boolean sorting, Integer page, Integer pageSize) {
        return this.flatPushMessageInformationDao.findAllForPushApplication(pushApplicationID, search, sorting, page, pageSize);
    }

    public long countMessagesForPushApplication(String pushApplicationId) {
        return this.flatPushMessageInformationDao.getNumberOfPushMessagesForPushApplication(pushApplicationId);
    }

    public void deleteOutdatedFlatPushInformationData() {
        Date historyDate = DateUtils.calculatePastDate((int)ConfigurationUtils.tryGetGlobalIntegerProperty((String)AEROGEAR_METRICS_STORAGE_MAX_DAYS, (Integer)30));
        logger.trace("Delete all until {}", (Object)historyDate.getTime());
        this.flatPushMessageInformationDao.deletePushInformationOlderThan(historyDate);
    }

    public FlatPushMessageInformation getPushMessageInformation(String id) {
        return (FlatPushMessageInformation)this.flatPushMessageInformationDao.find((Object)id);
    }

    public void updateAnalytics(String aerogearPushId) {
        FlatPushMessageInformation pushMessageInformation = this.getPushMessageInformation(aerogearPushId);
        if (pushMessageInformation != null) {
            if (pushMessageInformation.getFirstOpenDate() != null) {
                pushMessageInformation.setLastOpenDate(new Date());
            } else {
                pushMessageInformation.setFirstOpenDate(new Date());
                pushMessageInformation.setLastOpenDate(new Date());
            }
            logger.trace("Incrementing 'open counter' for Push Notification '{}' ", (Object)aerogearPushId);
            pushMessageInformation.incrementAppOpenCounter();
        }
    }
}

